(***************************************************
TColorButton->TColorPanel

A simple descendant of TColorPanel that provides some
nive default effects for MouseDown and MouseUp.

TColorToggle->TColorPanel

Another descendant of TColorPanel that acts as a toggle.

Properties

Down
  Controls the toggle's state.
***************************************************)

unit ColorButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ColorPanel;

type

  TColorButton = class( TColorPanel )
  private
     FSaveColor: byte;
  protected
     procedure MouseDown( Button: TMouseButton; Shift: TShiftState; X, Y: Integer ); override;
     procedure MouseUp( Button: TMouseButton; Shift: TShiftState; X, Y: Integer ); override;
  public
  published
     constructor Create( AOwner: TComponent ); override;
  end;

procedure Register;

implementation

(***************************************************
Some new defaults.
***************************************************)
constructor TColorButton.Create( Aowner: TComponent );
begin
  inherited Create( AOwner );
  BlackOutline := FALSE;
  Rollover := TRUE;
end;

(***************************************************
When the button is "pressed" draw in shadow color.
***************************************************)
procedure TColorButton.MouseDown( Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
begin
  BevelOuter := bvLowered;
  FSaveColor := ColorIndex;
  ColorIndex := ColorIndexShadow;
  inherited MouseDown( Button, Shift, X, Y );
end;

(***************************************************
Restore the color when the mouse is lifted.
***************************************************)
procedure TColorButton.MouseUp( Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
begin
  BevelOuter := bvRaised;
  ColorIndex := FSaveColor;
  inherited MouseUp( Button, Shift, X, Y );
end;

procedure Register;
begin
  RegisterComponents( 'Vis', [TColorButton] );
end;

end.
