{ Percent Tester - test program for the TPercentDlg object, declared in
	"percent.pas". Have a ball.

	Steve Willer
}


program PctTest;

{$R Percent.res}

uses WinProcs,WinTypes,Strings,WObjects,Percent;

type
	TPctTestApp = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PPctTestWindow = ^TPctTestWindow;
	TPctTestWindow = object(TPercentDlg)
		TimerH:word;
		TimerUp:boolean;
		procedure SetupWindow; virtual;
		procedure WMTimer(var Msg:TMessage); virtual wm_Timer;
		procedure Cancel(var Msg:TMessage); virtual id_First+id_Cancel;
		destructor Done; virtual;
	end;

procedure TPctTestApp.InitMainWindow;
begin
	MainWindow := New(PPctTestWindow,Init(nil,'Percent_2',2,true));
end;

procedure TPctTestWindow.SetupWindow;
begin
	TPercentDlg.SetupWindow;
	TimerH:=SetTimer(HWindow,20,200,nil);
	TimerUp:=true;
	SetText('Percentage Test',0);
	SetText('Displaying Percentages',1);
	SetText(nil,3);
	SetText(nil,4);
end;

procedure TPctTestWindow.WMTimer(var Msg:TMessage);
var PctStr:string;
		PctText:array[0..50] of char;
begin
	if TimerUp then AddPctLevel(7,1) else DelPctLevel(7,1);
	if TimerUp then AddPctLevel(7,2) else DelPctLevel(7,2);
	if ((PctCurrent[1]=PctHigh[1]) or (PctCurrent[1]=PctLow[1])) then
		TimerUp:=not TimerUp;
	str(PctCurrent[1],PctStr);
	PctStr:='Current percentage: '+PctStr;
	StrPCopy(PctText,PctStr);
	SetText(PctText,2);
end;

procedure TPctTestWindow.Cancel(var Msg:TMessage);
begin
	CloseWindow;
end;

destructor TPctTestWindow.Done;
begin
	KillTimer(HWindow,20);
	TPercentDlg.Done;
end;

var Pct:TPctTestApp;

begin
	Pct.Init('PercentApp');
	Pct.Run;
	Pct.Done;
end.
