unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Box, ExtCtrls;

type
  TfrmScrnSave = class(TForm)

    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    bFirst, bConfig: Boolean;
    bDrawing: Boolean;
    Box: TBox;

    procedure TerminateScrnSave;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmScrnSave: TfrmScrnSave;

implementation

uses
  Config;

{$R *.DFM}

procedure TfrmScrnSave.TerminateScrnSave;
begin
  Box.Free;
  Halt(0);
end;

procedure TfrmScrnSave.FormCreate(Sender: TObject);
var
  i: integer;
begin
  bFirst := true;
  bConfig := false;
  bDrawing := false;

  SetBounds (0, 0, 0, 0);     { Avoid the blinking effect }

  for i:=1 to ParamCount do
    if ParamStr(i)='/c' then bConfig := true;

  if not bConfig then
  begin
    WindowState := wsMaximized;      { Make the window BIG }
  end;
end;

procedure TfrmScrnSave.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  TerminateScrnSave;
end;

procedure TfrmScrnSave.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  TerminateScrnSave;
end;

procedure TfrmScrnSave.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if not bFirst then TerminateScrnSave;
  bFirst := false;
end;

procedure TfrmScrnSave.FormShow(Sender: TObject);
begin
  if bConfig then
  begin
    frmConfig.ShowModal;
    Close;
  end
  else
  begin
    { Hide tbe cursor }
    SetCursorPos(Screen.Width,Screen.Height);

    { Make a box object and let it draw itself on the forms Canvas }
    Box := TBox.Init(Canvas, 100);

    { Make a timer so that the image will be updated regularly }
{    Timer1.Enabled := true;}
  end

end;

{ Could have used a timer instead of this but Timers are
  valuable resources not to be wasted. However the Clock is
  very in acurate in the PC so no real accuracy can be
  expected }
procedure TfrmScrnSave.FormPaint(Sender: TObject);
var
  lastTime, Fract: Real;
begin
  { Want to make sure I am only running one instance }
  if not bDrawing then
    bDrawing:= true;

    { 10 ms fraction (1000ms * 60s * 60m * 24h /10 ms = 8640000 }
    Fract := 50/86400000; { 50 ms About as accurate as the PC clock can be }

    Box.Draw;
    lastTime := Time;
    while true do
    begin
      Application.ProcessMessages;
      if Time > lastTime+Fract then
      begin
        Box.Rotate;
        lastTime := Time;
      end;
    end;
end;


end.
