unit PopupBtn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, DsgnIntf;

type
  TAboutPopupButton = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TPopupPlace = (ppRight, ppDown);

  TPopupButton = class(TSpeedButton)
  private
    FDisableAp: boolean;
    FPopupPlace: TPopupPlace;
    AboutBox: TAboutPopupButton;
    procedure SetPopupPlace(Value: TPopupPlace);
    procedure SetDisableAp(Value: boolean);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  protected
    procedure Click; override;
  published
    property About: TAboutPopupButton read AboutBox write AboutBox;
    property PopupPlace: TPopupPlace read FPopupPlace write SetPopupPlace;
    property DisableAutoPopup: boolean read FDisableAp write SetDisableAp;
    property PopupMenu;
  end;


procedure Register;

implementation

procedure TAboutPopupButton.Edit;
begin
  Application.MessageBox('TPopupButton component v1.00 for Delphi 2.0. (C) 1997 Ivan Azic. For details, see README.TXT file.',
                         'About TPopupButton Component', MB_OK + MB_ICONINFORMATION);
end;

function TAboutPopupButton.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutPopupButton.GetValue: string;
begin
  Result:= '(about)';
end;

procedure TPopupButton.SetPopupPlace(Value: TPopupPlace);
begin
  FPopupPlace:= Value;
end;

procedure TPopupButton.SetDisableAp(Value: boolean);
begin
  FDisableAp:= Value;
end;

procedure TPopupButton.Click;
var
  q: TPoint;
begin
  inherited Click;
  if PopupMenu = nil then exit;
  PopupMenu.AutoPopup:= not(FDisableAp);
  q.X:= 0;
  q.Y:= 0;
  q:= ClientToScreen(q);
  if FPopupPlace = ppRight then
    PopupMenu.Popup(q.X + Width, q.Y - 1)
  else
    PopupMenu.Popup(q.X - 1, q.Y + Height);
end;

constructor TPopupButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Caption:= '&Popup Button';
  Width:= 81;
end;

destructor TPopupButton.Destroy;
begin
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TPopupButton]);
  RegisterPropertyEditor(TypeInfo(TAboutPopupButton), TPopupButton, 'ABOUT', TAboutPopupButton);
end;

end.
