{ TOvrMemo
  --------
  An improved TMemo component which reflect keyboard
  insert/overwrite mode, Special desiged for Windows
  Traditional Chinese Version.

  by Wolfgang Chien <wolfgang@ms2.hinet.net>
}
unit OMemo;

interface

uses
{$ifdef Windows}
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;
{$endif}

{$ifdef Win32}
  SysUtils, Windows, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;
{$endif}

type
  TInsertKeyStates = (iksInsert, iksOverWrite);

  TOvrMemo = class(TMemo)
  private
    procedure WMChar(var Msg: TWMKey); message WM_Char;
  protected
    function GetInsertKeyState: TInsertKeyStates;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property InsertKeyState: TInsertKeyStates read GetInsertKeyState;
  published

  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TOvrMemo]);
end;

constructor TOvrMemo.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

(* -------------------------------------------------- *)
destructor TOvrMemo.Destroy;
begin
  inherited Destroy;
end;

(* -------------------------------------------------- *)
function TOvrMemo.GetInsertKeyState: TInsertKeyStates;
begin
  if GetKeyState(VK_INSERT) = 0 then
    Result := iksInsert
  else
    Result := iksOverWrite;
end;

(* -------------------------------------------------- *)
procedure TOvrMemo.WMChar(var Msg: TWMKey);
begin
  { if Overwrite state and user select nothing }
  if (InsertKeyState = iksOverWrite) and (SelLength = 0)
    and (SelStart < GetTextLen) then
  begin
    if Ord(Msg.CharCode) < 32 then
      SelLength := 0
    else
    begin
      SelLength := 2;
      case SelText[1] of
        #9: SelLength := 1;  { Tab }
        #13, #10: SelLength := 0; { Line End }
      else
        begin
          if Ord(Msg.CharCode) > 127 then { Chinese Word Lead-byte, BIG5 }
          begin
            { Only one char before the end of Line }
            if (SelText[2] in [#13, #10]) then
              SelLength := 1
            else
              SelLength := 2
          end
          else
            SelLength := 1;
        end;
      end;
    end;
  end;

  inherited;
end;

end.

