{ Two different ways of showing transparent bitmaps }
{ Some small changes were made by Nuno Antunes      }

unit XParBMP;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;


procedure DrawTransparent(t: TBitmap; x,y: Integer; s: TBitmap; TrCol: TColor);
procedure DrawTransparentBitmap (ahdc: HDC; Image: TBitmap;
               xStart, yStart: Word; TrCol: Tcolor);


implementation

{ Purpose:  Display a transparent bitmap loaded from a file
  Author:   Michael Vincze (vincze@ti.com)
  Date:     04/20/95
  Usage:    Create a blank form, named Form1, compile and run.
  Limits:   This unit has been tested for both 16 and 256 color bitmaps.
            It is assumed that the lower left pixel of the bitmap represents
            the transparent color.
  Notes:    If this file is to be used for any purpose please leave
            this header intact and give credit to the author if used for
            any purpose.
            Please contact the author if any improvements are made.
            The author stakes no claim for this programs usefullness
            or purpose.
  Version:  1.00  04/20/95  Initial creation
}
procedure DrawTransparentBitmap (ahdc: HDC;
                                 Image: TBitmap;
                                 xStart, yStart: Word;
                                 TrCol : Tcolor);
var
  TransparentColor: TColor;
  cColor          : TColorRef;
  bmAndBack,
  bmAndObject,
  bmAndMem,
  bmSave,
  bmBackOld,
  bmObjectOld,
  bmMemOld,
  bmSaveOld       : HBitmap;
  hdcMem,
  hdcBack,
  hdcObject,
  hdcTemp,
  hdcSave         : HDC;
  ptSize          : TPoint;
begin
{ set the transparent color to be the lower left pixel of the bitmap
}
{TransparentColor := Image.Canvas.Pixels[0,Image.Height - 1];}
TransparentColor := TrCol;
TransparentColor := TransparentColor or $02000000;

hdcTemp := CreateCompatibleDC (ahdc);
SelectObject (hdcTemp, Image.Handle); { select the bitmap }

{ convert bitmap dimensions from device to logical points
}
ptSize.x := Image.Width;
ptSize.y := Image.Height;
DPtoLP (hdcTemp, ptSize, 1);  { convert from device logical points }

{ create some DCs to hold temporary data
}
hdcBack   := CreateCompatibleDC(ahdc);
hdcObject := CreateCompatibleDC(ahdc);
hdcMem    := CreateCompatibleDC(ahdc);
hdcSave   := CreateCompatibleDC(ahdc);

{ create a bitmap for each DC
}

{ monochrome DC
}
bmAndBack   := CreateBitmap (ptSize.x, ptSize.y, 1, 1, nil);
bmAndObject := CreateBitmap (ptSize.x, ptSize.y, 1, 1, nil);

bmAndMem    := CreateCompatibleBitmap (ahdc, ptSize.x, ptSize.y);
bmSave      := CreateCompatibleBitmap (ahdc, ptSize.x, ptSize.y);

{ each DC must select a bitmap object to store pixel data
}
bmBackOld   := SelectObject (hdcBack, bmAndBack);
bmObjectOld := SelectObject (hdcObject, bmAndObject);
bmMemOld    := SelectObject (hdcMem, bmAndMem);
bmSaveOld   := SelectObject (hdcSave, bmSave);

{ set proper mapping mode
}
SetMapMode (hdcTemp, GetMapMode (ahdc));

{ save the bitmap sent here, because it will be overwritten
}
BitBlt (hdcSave, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);

{ set the background color of the source DC to the color.
  contained in the parts of the bitmap that should be transparent
}
cColor := SetBkColor (hdcTemp, TransparentColor);

{ create the object mask for the bitmap by performing a BitBlt()
  from the source bitmap to a monochrome bitmap
}
BitBlt (hdcObject, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);

{ set the background color of the source DC back to the original color
}
SetBkColor (hdcTemp, cColor);

{ create the inverse of the object mask
}
BitBlt (hdcBack, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, NOTSRCCOPY);

{ copy the background of the main DC to the destination
}
BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y, ahdc, xStart, yStart, SRCCOPY);

{ mask out the places where the bitmap will be placed
}
BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, SRCAND);

{ mask out the transparent colored pixels on the bitmap
}
BitBlt (hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcBack, 0, 0, SRCAND);

{ XOR the bitmap with the background on the destination DC
}
BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCPAINT);

{ copy the destination to the screen
}
BitBlt (ahdc, xStart, yStart, ptSize.x, ptSize.y, hdcMem, 0, 0, SRCCOPY);

{ place the original bitmap back into the bitmap sent here
}
BitBlt (hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcSave, 0, 0, SRCCOPY);

{ delete the memory bitmaps
}
DeleteObject (SelectObject (hdcBack, bmBackOld));
DeleteObject (SelectObject (hdcObject, bmObjectOld));
DeleteObject (SelectObject (hdcMem, bmMemOld));
DeleteObject (SelectObject (hdcSave, bmSaveOld));

{ delete the memory DCs
}
DeleteDC (hdcMem);
DeleteDC (hdcBack);
DeleteDC (hdcObject);
DeleteDC (hdcSave);
DeleteDC (hdcTemp);
end;


{=================================================================}
{This procedure will draw a source bitmap onto a target bitmap,
 leaving information from the taget to shine through where the
 pixels in the source are of the specified transparent color.
 t   = The target bitmap to be drawn onto
 x,y = The position on the target where source is drawn
 s   = The source bitmap
 TrCol = The color that will become transparent in the source bmp
 NOTE: Don't forget to repaint the target, eg Image1.Invalidate}

procedure DrawTransparent(t: TBitmap; x,y: Integer; s: TBitmap; TrCol: TColor);
var
  bmpXOR, bmpAND, bmpINVAND, bmpTarget: TBitmap;
  oldcol: Longint;
begin
  try
   bmpAND        := TBitmap.Create;
   bmpAND.Width  := s.Width;
   bmpAND.Height := s.Height;
   bmpAND.Monochrome := True;
 
   oldcol := SetBkColor(s.Canvas.Handle, ColorToRGB(TrCol));

   BitBlt(bmpAND.Canvas.Handle, 0,0, s.Width, s.Height,
               s.Canvas.Handle, 0,0, SRCCOPY);
 
   SetBkColor(s.Canvas.Handle, oldcol);


   bmpINVAND       := TBitmap.Create;
   bmpINVAND.Width := s.Width;
   bmpINVAND.Height:= s.Height;
   bmpINVAND.Monochrome := True;
 
   BitBlt(bmpINVAND.Canvas.Handle, 0,0, s.Width, s.Height,
             bmpAND.Canvas.Handle, 0,0, NOTSRCCOPY);
 
   bmpXOR        := TBitmap.Create;
   bmpXOR.Width  := s.Width;
   bmpXOR.Height := s.Height;
 
   BitBlt(bmpXOR.Canvas.Handle, 0,0, s.Width, s.Height,
               s.Canvas.Handle, 0,0, SRCCOPY);
 
   BitBlt(bmpXOR.Canvas.Handle, 0,0, s.Width, s.Height,
       bmpINVAND.Canvas.Handle, 0,0, SRCAND);
 
   bmpTarget        := TBitmap.Create;

   bmpTarget.Width  := s.Width;
   bmpTarget.Height := s.Height;

   BitBlt(bmpTarget.Canvas.Handle, 0,0, s.Width, s.Height,
                  t.Canvas.Handle, x,y, SRCCOPY);
 
   BitBlt(bmpTarget.Canvas.Handle, 0,0, s.Width,s.Height,
             bmpAND.Canvas.Handle, 0,0, SRCAND);
 
   BitBlt(bmpTarget.Canvas.Handle, 0,0, s.Width,s.Height,
             bmpXOR.Canvas.Handle, 0,0, SRCINVERT);
 
   BitBlt(t.Canvas.Handle,   x,y, s.Width, s.Height,
    bmpTarget.Canvas.Handle, 0,0, SRCCOPY);
 
  finally
   bmpXOR.Free;
   bmpAND.Free;
   bmpINVAND.Free;
   bmpTarget.Free;

  end;{End of TRY section}
end;
{=================================================================}

end.

