unit mStrDem_;

{Version 2.1b, 12.11.1996

Changed: Data are seperated by Tabs (#9) to test AM/PM date formats
Changed: Click on fixed cells sorts now the whole table}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, ExtCtrls, Spin, mStrGrid;

type
  TForm1 = class(TForm)
    AbbruchBtn: TBitBtn;
    Key_Type: TRadioGroup;
    RowCnt: TSpinEdit;
    ColCnt: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    SaveBtn: TButton;
    loadBtn: TButton;
    Panel1: TPanel;
    InsCol: TButton;
    InsRow: TButton;
    DelCol: TButton;
    DelRow: TButton;
    Anz: TSpinEdit;
    Panel2: TPanel;
    Search: TEdit;
    Nextbtn: TButton;
    FindBtn: TButton;
    Substring_Search: TCheckBox;
    RowWise: TCheckBox;
    FindZeile: TButton;
    FindSpalte: TButton;
    Use_fixed: TRadioGroup;
    Panel3: TPanel;
    SpaltenSortBtn: TBitBtn;
    ZeilenSortBtn: TButton;
    SortRows: TButton;
    SortCols: TButton;
    SortThisRow: TButton;
    SortThisCol: TButton;
    Label3: TLabel;
    Label4: TLabel;
    FixCol: TSpinEdit;
    FixRow: TSpinEdit;
    Reverse: TCheckBox;
    UndoSort: TButton;
    mStrGrid1: TmStrGrid;
    Label5: TLabel;
    Descending: TCheckBox;
    AllowClickOnFixed: TCheckBox;
    format: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure AbbruchBtnClick(Sender: TObject);
    procedure SpaltenSortBtnClick(Sender: TObject);
    procedure ZeilenSortBtnClick(Sender: TObject);
    procedure Key_TypeClick(Sender: TObject);
    procedure Use_fixedClick(Sender: TObject);
    procedure NextbtnClick(Sender: TObject);
    procedure FindBtnClick(Sender: TObject);
    procedure Substring_SearchClick(Sender: TObject);
    procedure RowWiseClick(Sender: TObject);
    procedure FindZeileClick(Sender: TObject);
    procedure FindSpalteClick(Sender: TObject);
    procedure SortRowsClick(Sender: TObject);
    procedure SortColsClick(Sender: TObject);
    procedure InsColClick(Sender: TObject);
    procedure DelRowClick(Sender: TObject);
    procedure InsRowClick(Sender: TObject);
    procedure DelColClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure RowCntChange(Sender: TObject);
    procedure ColCntChange(Sender: TObject);
    procedure loadBtnClick(Sender: TObject);
    procedure SortThisRowClick(Sender: TObject);
    procedure SortThisColClick(Sender: TObject);
    procedure FixColChange(Sender: TObject);
    procedure FixRowChange(Sender: TObject);
    procedure ReverseClick(Sender: TObject);
    procedure UndoSortClick(Sender: TObject);
    procedure DescendingClick(Sender: TObject);
    procedure mStrGrid1Click(Sender: TObject);
    procedure AllowClickOnFixedClick(Sender: TObject);
    procedure formatChange(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var Search_Rowwise:boolean;
    max_rows:integer;
    
procedure update_size;
begin with form1,mStrGrid1 do
begin RowCnt.value:=RowCount;
      ColCnt.value:=ColCount;
      FixRow.value:=FixedRows;
      FixCol.value:=FixedCols;
end end;

procedure TForm1.FormCreate(Sender: TObject);
begin with mStrGrid1 do
      begin Use_fixed.itemindex:=ord(UseFixed);
            Search_Rowwise:=true;
            Substring_search.checked:=SearchSubstring;
            loadFromFile('mStrDemo.dat',#9);
            update_size;
            max_rows:=rowcount;
            format.text:=DateTimeFormat
end   end;

procedure TForm1.AbbruchBtnClick(Sender: TObject);
begin close end;

procedure TForm1.SpaltenSortBtnClick(Sender: TObject);
begin with mStrGrid1 do
      SortCompleteColumns(row)
end;

procedure TForm1.ZeilenSortBtnClick(Sender: TObject);
begin with mStrGrid1 do
      SortCompleteRows(col)
end;

procedure TForm1.Key_TypeClick(Sender: TObject);
begin with mStrGrid1 do
      case Key_Type.itemindex of
      0:keytype:=soString;
      1:keytype:=soStringCaseSensitive;
      2:keytype:=soNumeric;
      3:keytype:=soDate;
end end;

procedure TForm1.Use_fixedClick(Sender: TObject);
begin mStrGrid1.UseFixed:=HandleFixed(Use_fixed.itemindex) end;

procedure TForm1.Substring_SearchClick(Sender: TObject);
begin mStrGrid1.SearchSubstring:=Substring_search.checked; end;

procedure TForm1.RowWiseClick(Sender: TObject);
begin Search_Rowwise:=Rowwise.checked; end;

procedure TForm1.NextbtnClick(Sender: TObject);
var c,r:integer;
begin with mStrGrid1 do
      if findnext(c,r)
      then begin col:=c; row:=r;
           end
      else begin nextbtn.enabled:=false;
                 setfocus
end        end;
          
procedure TForm1.FindBtnClick(Sender: TObject);
var c,r:integer;
begin with mStrGrid1 do
      if findfirst(search.text,Search_Rowwise,c,r)
      then begin col:=c; row:=r;
                 nextbtn.enabled:=true;
           end
      else begin nextbtn.enabled:=false;
                 setfocus
end        end;

procedure TForm1.FindZeileClick(Sender: TObject);
var c,r:integer;
begin with mStrGrid1 do
      if findfirstinrow(search.text,row,c,r)
      then begin col:=c; row:=r;
                 nextbtn.enabled:=true;
           end
      else begin nextbtn.enabled:=false;
                 setfocus
end        end;

procedure TForm1.FindSpalteClick(Sender: TObject);
var c,r:integer;
begin with mStrGrid1 do
      if findfirstincol(search.text,col,c,r)
      then begin col:=c; row:=r;
                 nextbtn.enabled:=true;
           end
      else begin nextbtn.enabled:=false;
                 setfocus
end        end;

procedure TForm1.SortRowsClick(Sender: TObject);
begin mStrGrid1.SortAllRows end;

procedure TForm1.SortColsClick(Sender: TObject);
begin mStrGrid1.SortAllCols end;

procedure TForm1.SortThisRowClick(Sender: TObject);
begin with mStrGrid1 do sortrow(row) end;

procedure TForm1.SortThisColClick(Sender: TObject);
begin with mStrGrid1 do sortcol(col) end;

procedure TForm1.DescendingClick(Sender: TObject);
begin mStrGrid1.SortDescending:=Descending.checked end;

procedure TForm1.UndoSortClick(Sender: TObject);
begin mStrGrid1.UndoSort end;

procedure TForm1.InsColClick(Sender: TObject);
begin with mStrGrid1 do InsertCols(Col,Anz.value);
      update_size
end;

procedure TForm1.DelRowClick(Sender: TObject);
begin with mStrGrid1 do DeleteRows(Row,Anz.value);
      update_size
end;

procedure TForm1.InsRowClick(Sender: TObject);
begin with mStrGrid1 do InsertRows(Col,Anz.value);
      update_size
end;

procedure TForm1.DelColClick(Sender: TObject);
begin with mStrGrid1 do DeleteCols(Col,Anz.value);
      update_size
end;

procedure TForm1.loadBtnClick(Sender: TObject);
begin with mStrGrid1 do
begin LoadFromFile('mStrDemo.dat',#9);
      fixedrows:=1; fixedcols:=1;
      update_size
end end;

procedure TForm1.SaveBtnClick(Sender: TObject);
begin mStrGrid1.savetofile('mStrDemo.dat',#9) end;

procedure TForm1.RowCntChange(Sender: TObject);
var i:integer;
begin with mStrGrid1 do
begin RowCount:=RowCnt.value;
      if RowCount>max_rows then
       begin for i:=max_rows to rowCount-1 do
              cells[0,i]:='#'+inttostr(i);
             max_rows:=rowcount;
end end end;

procedure TForm1.ColCntChange(Sender: TObject);
begin mStrGrid1.ColCount:=ColCnt.value end;

procedure TForm1.FixColChange(Sender: TObject);
begin mStrGrid1.fixedcols:=FixCol.value end;

procedure TForm1.FixRowChange(Sender: TObject);
begin mStrGrid1.fixedrows:=FixRow.value end;

procedure TForm1.ReverseClick(Sender: TObject);
var c,r:integer;
begin with mStrGrid1 do
begin ReverseSearch:=Reverse.checked;
      if SearchExists then
       begin NextBtn.enabled:=true;
             findnext(c,r);
             col:=c; row:=r;
end end end;

procedure TForm1.AllowClickOnFixedClick(Sender: TObject);
begin with mStrGrid1 do ClickFixed:=NOT ClickFixed end;

procedure TForm1.mStrGrid1Click(Sender: TObject);
{This procedure checks if you clicked on a fixed cell. If so, (and ClickFixed = TRUE)
 then the sorting direction is changed and this col or row is sorted.
 The direction of sorting is here hidden in the objects property. Normally it is a
 pointer to further information, but it is good enough to hold a 4 byte value.
 (This works without memory allocation!)
 When using first, the initial value (whatever it is) is set to 1 and the whole table
 is sorted ascending. The next click finds the 1, sorts descending and set a 2}
begin with mStrGrid1 do
      if (row<SavedFixedRows) and (col>=SavedFixedCols) then
        if Integer(objects[col,row])=1  {The pointer is converted to an integer}
         then begin {ascending -> descending}
                    SortDescending:=true;
                    SortCompleteRows(col);
                    objects[col,row]:=TObject(2); {The integer is converted to the pointer}
              end
         else begin { -> ascending}
                    SortDescending:=false;
                    SortCompleteRows(col);
                    objects[col,row]:=TObject(1)
              end else
      if (col<SavedFixedCols) and (row>=SavedFixedRows) then
        if Integer(objects[col,row])=1
         then begin {ascending -> descending}
                    SortDescending:=true;
                    SortCompleteColumns(row);
                    objects[col,row]:=TObject(2);
              end
         else begin { -> ascending}
                    SortDescending:=false;
                    SortCompleteColumns(row);
                    objects[col,row]:=TObject(1)
end           end;

procedure TForm1.formatChange(Sender: TObject);
begin {Warnig: Every change is interpreted! Illegal format while editing must be suppressed.
      Please compile with Tools / Options / Preferences / Debugging / Do not stop in an exception}
      try mStrGrid1.DateTimeFormat:=format.text
      except
end   end;

end.
