unit Movbut;
{
  Moving Button Component
  John Baumbach                         Delphi 1.0
  email: mantis@vcnet.com               Copyright (c) 7-17-96
  http://www.vcnet.com/mantis              by John Baumbach

  Installation Instructions:
  To check out a sample application without installing
  the component, load the project file "movingbt.dpr" with
  the Delphi editor and run.  If you have an error like
  "Can't execute a DLL", make sure the sample form is loaded
  by "View | Forms | ButtonObject", then clicking "OK".

  If you have an error like "Invalid File Name" during compile time
  change your "Options | Project | Directories-Conditionals |
  Output Directory" to the name of the directory which has the
  unzipped files (if Delphi is set up to produce an output file).

  Installing Component to Toolbar:
  This component is currently set up to be added to the "Samples"
  palette of the toolbar.  If you wish to add it to a different
  one, change the word "Samples" to the name of the desired
  palette in the "Register" procedure below.

  Select "Options | Install Components" and select "Add", then
  "movbut.pas" from the directory where you unzipped this file.
  Delphi will then recompile the toolbar and the "TMovingButton"
  component will be added to the palette!

  If you want to keep this component permanently, copy the "movebut.pas"
  and "movebut.dcr" files to the "Delphi\LIB" subdirectory and follow the
  above installation step.

  You can remove the component at any time the same way, except choose
  "Options | Install Components" and choose "Movbut" to remove.

  Using the MovingButton:
  Once installed in toolbar, you can use it just like the "TBitBtn"
  component.  The button is designed to move around inside the parent
  rectangle, whether it's the entire form or a container such as a panel.
  The sample application uses three panels to house the three buttons, with
  no bevel so the panels are invisible.

  The new properties are "PixelsPerMove", "MoveInterval" and
  "IsMoving".  PixelsPerMove is how many pixels the button will move each
  time it moves, MoveInterval is how many milliseconds between moves, and
  IsMoving is whether or not the button is currently moving.

  Performance:
  On a 486-100 with 16 megs under Win95 and the default of
  100 milliseconds for "MoveInterval", the system is able to handle
  a maximum of the following number of buttons before bogging down
  (during run time)

            TBitBtn Ancestor:
                       No Glyphs:      9 buttons
                      With Glyph:      8 buttons

  During design time, they will bog down sooner.  Setting the timer
  to a longer delay will allow more buttons to be added without bogging.

  Changing the ancestor to "TButton" doesn't affect performance.

  Enhancements:
  Currently, the buttons will take up system CPU cycles even
  when "IsMoving" is set to false.  Once the parent of the button is destroyed
  all the resources are freed, so this shouldn't be too much of a problem.

  Also, dragging buttons around (while they're moving) during design
  time leaves tracers on the screen.  This is harmless but annoying.
  To remedy, I would set "IsMoving" to false during design time.

  I plan to add: animation to the glyphs, scrolling text, and growing and
  shrinking button sizes.  I just need to find the time.

  If you want to edit the bitmap that appears on the palette, the image
  is located in the "movebut.dcr" file.  Use the Delphi Image Editor to
  edit the bitmap and save it back to this resource file.  Don't change
  the name of the bitmap in the resource file or it won't be added to
  the palette.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons;

type
   TMovingButton = class(TBitBtn)
   procedure ButtonTimerTimer(Sender: TObject);   { added procedure }
   private
      xdir, ydir: integer;            { variables in procedure }
      speed, minterval: integer;
      ButtonTimer: TTimer;
      buttonmoving: boolean;
   public
      constructor Create(AOwner: TComponent); override;
   published
      { additional properties to go onto object inspector panel }
      property MoveInterval: integer read minterval
         write minterval default 100;
      property PixelsPerMove: integer read speed
         write speed default 1;
      property IsMoving: boolean read buttonmoving
         write buttonmoving;
end;  { of type }

procedure Register;

implementation

procedure Register;         { registers with toolbar when being installed }
begin
    RegisterComponents('Samples', [TMovingButton]);
end;

constructor TMovingButton.Create(AOwner: TComponent);
begin                                 { procedure to create button type and }
    inherited Create(AOwner);         { set default behavior                }
                                      { "Inherited" means it gets all the   }
                                      { properties of TBitBtn               }
    minterval:=100;                   { time in milliseconds between moves }
    speed:=1;                         { pixels per move }
    xdir:=speed;
    ydir:=speed;
    width:=127;                       { button width }
    spacing:=10;                      { glyph spacing }
    font.color:=clBtnText;            { Delphi uses "clWindowText" by default, which   }
                                      { is odd...                                      }
    ButtonTimer:=TTimer.Create(Self);      { create the timer }
    with ButtonTimer do begin
        Enabled:=true;                      { turn timer on }
        interval:=minterval;                { set interval  }
        OnTimer:=ButtonTimerTimer;          { point to movment procedure }
    end;
    buttonmoving:=true;                     { set button in motion }
end;

procedure TMovingButton.ButtonTimerTimer(Sender: TObject);
begin
    try
       ButtonTimer.Interval:=minterval;          { update interval }
       if xdir > 0 then xdir:=speed else xdir :=speed * -1;   { update speed }
       if ydir > 0 then ydir:=speed else ydir :=speed * -1;
       if buttonmoving then begin
          if xdir > 0 then begin     { moving right }
             if (left + width + xdir) <= parent.clientrect.right then
                 left := left + xdir
             else
                 xdir:=xdir * -1;  { change sign if can't go right }
          end
          else  { moving left }
             if (left + xdir) >= parent.clientrect.left then
                 left:=left + xdir
             else
                xdir:=xdir * -1;    { change sign if can't go left }
          if ydir > 0 then begin     { moving down }
             if (top + height + ydir) <= parent.clientrect.bottom then
                 top := top + ydir
             else
                 ydir:=ydir * -1;     { change sign if can't go down }
          end
          else  { moving up }
             if (top + ydir) >= parent.clientrect.top then
                 top:=top + ydir
             else
                ydir:=ydir * -1;     { change sign if can't go up }
       end;
    except
       {The button has been destroyed!!!}
       ButtonTimer.Enabled:=false;
    end;
end;

end.
