////////////////////
//
//	mapi.ch - Messaging API definitions
//
//	Written by:	John M. Skelton,  12-Jan-95.
//
//	Copyright (C) 1995 Skelton Software, Kendal Cottage, Hillam, Leeds, UK.
//	All Rights Reserved.
//
////////////////////


#ifndef	C4W_MAPI_CH
#define	C4W_MAPI_CH

// MAPI constants:

#define	MAPI_LOGON_UI		1	// show login dialog
#define	MAPI_NEW_SESSION	2	// 
#define	MAPI_ENVELOPE_ONLY	64	// 0x  40 header info (to/from/etc.)
#define	MAPI_PEEK		128	// 0x  80 don't change Read status
#define	MAPI_GUARANTEE_FIFO	256	// 0x 100 process in date/time order
#define	MAPI_FORCE_DOWNLOAD	4096	// 0x1000 download new messages
// TBD: more!

// MAPI status codes:
#define	SUCCESS_SUCCESS		0
#define	MAPI_E_NO_MESSAGES	16
// TBD: more!


// MAPI structures:

// MAPI FileDesc
//
// Here an array is used, one elem for each member of the MapiFileDesc structure

#define	MAPI_Rsvd	1		// reserved
#define	MAPI_FFlags	2		// 
#define	MAPI_Position	3		// 
#define	MAPI_PathName	4		// 
#define	MAPI_FileName	5		// 
#define	MAPI_FileType	6		// 

#define	MAPI_FLength	6		// length of array needed

// This is the best I can think of right now:
#define	MAPI_FILE_STRUCT_DEF	"DWORD,DWORD,DWORD,DWORD,DWORD,DWORD"


// MAPI RecipDesc
//
// Here an array is used, one elem for each member of the MapiRecipDesc structure

//#define	MAPI_Rsvd	1		// reserved
#define	MAPI_RecipClass	2		// 
#define	MAPI_Name	3		// 
#define	MAPI_Address	4		// 
#define	MAPI_EIDSize	5		// 
#define	MAPI_EntryID	6		// 

#define	MAPI_RLength	6		// length of array needed

// This is the best I can think of right now:
#define	MAPI_RECIP_STRUCT_DEF	"DWORD,DWORD,DWORD,DWORD,DWORD,DWORD"


// MAPI Message
//
// Here an array is used, one elem for each member of the MapiMessage structure

//#define	MAPI_Rsvd	1		// reserved
#define	MAPI_Subject	2		// 
#define	MAPI_NoteText	3		// 
#define	MAPI_MsgType	4		// 
#define	MAPI_DateRcvd	5		// 
#define	MAPI_ConvId	6		// 
#define	MAPI_Flags	7		// 
#define	MAPI_Originator	8		// 
#define	MAPI_RecipCount	9		// 
#define	MAPI_Recips	10		// array of MapiRecipDescs
#define	MAPI_FileCount	11		// 
#define	MAPI_Files	12		// array of MapiFileDescs

#define	MAPI_MsgLength	12		// length of array needed

// This is the best I can think of right now:
#define	MAPI_MSG_STRUCT_DEF	"DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD"


#endif	// C4W_MAPI_CH

