/////////////////////////
//
//	bin2ptr.prg - simple access to C pointers
//
//	Written by:	John M. Skelton, 12-Jan-95.
//
//	Copyright (C) 1995 Skelton Software, Kendal Cottage, Hillam, Leeds LS25 5HP, UK.
//	All Rights Reserved.
//
/////////////////////////


#define	GMEM_DDESHARE	8192		// magic number for Windows
#define	GMEM_MOVEABLE	2		// magic number for Windows


static	anPtr := {}
static	ahData := {}


// Convert a Clipper string to a C-style pointer
// (that won't move, regardless of Clipper VM activity)
//
// NOTE: You must call FreePtr() when you've finished with the pointer!

function Str2Ptr(cStr)			// --> nPtr
return Bin2Ptr(cStr + chr(0))


// Convert a Clipper binary data string to a C-style pointer
// (that won't move, regardless of Clipper VM activity)
//
// NOTE: You must call FreePtr() when you've finished with the pointer!

function Bin2Ptr(cData)		// --> nPtr
local	hData
local	nPtr, i

if cData == nil .or. (valtype(cData) == "N" .and. cData == 0)
	return 0		// NULL pointer
//else cData better be valtype() "C"!
endif

hData = GlobalAlloc(GMEM_MOVEABLE+GMEM_DDESHARE, len(cData))
nPtr = GlobalLock(hData)
C4W_Poke(nPtr, cData)
if (i := ascan(ahData, nil)) == 0
	aadd(ahData, hData)
	aadd(anPtr, nPtr)
else
	ahData[i] = hData
	anPtr[i] = nPtr
endif
return nPtr



// To get data back, use C4W_Peek()



// Free a pointer

function FreePtr(nPtr)
local	i

if nPtr != nil .and. nPtr != 0 .and. (i := ascan(anPtr, nPtr)) != 0
	GlobalUnlock(ahData[i])
	GlobalFree(ahData[i])
	ahData[i] := anPtr[i] := nil
endif
nPtr = 0			// if passed as @nPtr, it'll be NULLed
return nil

