unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, LOPanel, StdCtrls, Buttons, LOform;

type

  { Array of all possible relationships }
  TRelationshipNames = array [TRelationship] of string;

  { Array of all possible edges }
  TEdgeNames = array [TEdge] of string;

const

  { Names of all possible relationships }
  RelationshipNames : TRelationshipNames =
    ('lmAsIs', 'lmPercentOf', 'lmAbove', 'lmBelow', 'lmSameAs', 'lmAbsolute');

  { Names of all possible edges }
  EdgeNames : TEdgeNames =
    ( 'lmLeft', 'lmTop', 'lmRight', 'lmBottom', 'lmCenter', 'lmWidth', 'lmHeight' );

type
  TMainForm = class(TForm)
    LayoutPanel1: TLayoutPanel;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    Memo4: TMemo;
    Memo5: TMemo;
    Panel1: TPanel;
    LayoutBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    procedure LayoutPanel1BeforeLayout(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure LayoutBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetMetricsText( Memo : TMemo );
    function GetConstraintText( var loc : TLayoutConstraint ) : string;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{--------------------------------------- TMainForm.LayoutPanel1BeforeLayout }
{ Set metrics text for all memo controls }
procedure TMainForm.LayoutPanel1BeforeLayout(Sender: TObject);
var
  i : integer;
begin
  { change metrics text only if plan is dirty }
  if LayoutPanel1.PlanIsDirty then
    for i := 0 to LayoutPanel1.ControlCount - 1 do
      if LayoutPanel1.Controls[i] is TMemo then
        SetMetricsText( LayoutPanel1.Controls[i] as TMemo );
end; { TMainForm.LayoutPanel1BeforeLayout }

{--------------------------------------- TMainForm.SetMetricsText }
{ Set metrics text }
procedure TMainForm.SetMetricsText( Memo : TMemo );
var
  metr : TLayoutMetrics;
begin
  with Memo.Lines do
  begin
    Clear;
    Add( Memo.Name );

    if LayoutPanel1.GetChildLayoutMetrics( Memo, metr ) then
    begin
      Add( GetConstraintText( metr.X ) );
      Add( GetConstraintText( metr.Y ) );
      Add( GetConstraintText( metr.Width ) );
      Add( GetConstraintText( metr.Height ) );
    end {if}
  end {with}
end; { TMainForm.SetMetricsText }

{--------------------------------------- TMainForm.GetConstraintText }
{ Biuld sring from constraint }
function TMainForm.GetConstraintText( var loc : TLayoutConstraint ) : string;
var
  N, i : integer;

begin
  with loc do
  begin
    {Add my edge and relationship}
    Result := EdgeNames[MyEdge] + ', ' + RelationshipNames[Relationship];

    { if relationship is AsIs everything is done }
    if Relationship = lmAsIs then
      Exit;

    { Get number of relative control in listbox only if
      relationship is not Absolute }
    if Relationship <> lmAbsolute then
    begin
      Result := Result + ', ';

      if RelWin <> lmParent then
        Result := Result + RelWin.Name
      else
        Result := Result + 'lmParent';

      {Add relative edge}
      Result := Result + ', ' + EdgeNames[OtherEdge];
     end {if Relationship <> lmAbsolute}
    else
      Result := Result + ',,';

    { Add value only if relationship is not SameAs }
    if Relationship <> lmSameAs then
      Result := Result + ', ' + IntToStr( Value );
  end; {with}
end; { TMainForm.GetConstraintText }

{--------------------------------------- TMainForm.ExitBtnClick }
{ Close main form }
procedure TMainForm.ExitBtnClick(Sender: TObject);
begin
  Close;
end; { TMainForm.ExitBtnClick }

{--------------------------------------- TMainForm.LayoutBtnClick }
{ Show dialog for setting layout metrics }
procedure TMainForm.LayoutBtnClick(Sender: TObject);
var
  LayoutForm: TLayoutForm;
begin
  LayoutForm := TLayoutForm.Create( Application, LayoutPanel1 );
  LayoutForm.ShowModal;
  LayoutForm.Free;
end; { TMainForm.LayoutBtnClick }

end.
