unit MetrEdit;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
  Buttons, DsgnIntf, StdCtrls, LOForm, LOPanel;

type

  TMetricsProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  { Component editor - brings up merikcs editor when double clicking on
    Metrics property }
  TLayoutEditor = class(TDefaultEditor)
  public
    procedure EditProperty(PropertyEditor: TPropertyEditor;
      var Continue, FreeEditor: Boolean); override;
  end;

implementation

uses SysUtils;

{ TAnglesProperty }

{--------------------------------------- TMetricsProperty.Edit }
{ Edit property by displaying dialog }
procedure TMetricsProperty.Edit;
var
  LayoutPanel: TLayoutPanel;
  LayoutForm: TLayoutForm;
begin
  LayoutPanel := GetComponent(0) as TLayoutPanel;
  LayoutForm := TLayoutForm.Create( Application, LayoutPanel );
  try
    LayoutForm.ShowModal;
    if LayoutForm.Modified then
      Designer.Modified;
  finally
    LayoutForm.Free;
  end; {try}
end; { TMetricsProperty.Edit }

{--------------------------------------- TMetricsProperty.GetAttributes }
{ Attributes are - dialog and a lot of subproperties }
function TMetricsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [ paDialog ];
end; { TMetricsProperty.GetAttributes }

{TLayoutEditor}

{--------------------------------------- TLayoutEditor.EditProperty }
{ This is Layout panel Metrics property Editor }
procedure TLayoutEditor.EditProperty(PropertyEditor: TPropertyEditor;
  var Continue, FreeEditor: Boolean);
var
  PropName: string;
begin
  PropName := PropertyEditor.GetName;

  if ( CompareText( PropName, 'METRICS' ) = 0 ) and
     ( Component is TLayoutPanel ) and
     ( PropertyEditor is TMetricsProperty ) then
  begin
    PropertyEditor.Edit;
    Continue := False;
  end; {if}
end; { TLayoutEditor.EditProperty }

end.
