unit TEST_A1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, Crc32Calc;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    HelpItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    FileItem: TMenuItem;
    FileExitItem: TMenuItem;
    Bevel: TBevel;
    Memo: TMemo;
    CalcFileBtn: TButton;
    CalcMemBtn: TButton;
    CalcGenBtn: TButton;
    ExitBtn: TButton;
    OpenDialog: TOpenDialog;
    CrcCalc: TCRC32Calc;
    procedure FileExitItemClick(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CheckCalcFile(Sender: TObject);
    procedure CheckCalcmem(Sender: TObject);
    procedure CheckCalcGen(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
  private
    FStream :TStream;
    function GetFileName :TFileName;
    procedure ReadDataFromStream( pData :Pointer; var cbData :Integer );
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
  MessageDlg( 'TCRC32Calc Test'#13#10'(C) 1996 Glen Why',
   mtInformation, [ mbOk ], 0 );
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_ESCAPE then close;
end;

procedure TMainForm.CheckCalcFile(Sender: TObject);
var
  S :TFileStream;
  C :Longint;
  N :TFileName;
begin
  N := GetFileName;
  S := TFileStream.Create( N, fmOpenRead );
  try
    C := CrcCalc.CalcFile( S );
  finally
    S.free;
  end;
  memo.lines.add( format( 'CalcFile:'#09'File - %s'#09'CRC32 - %8x',
   [ ExtractFileName( N ), C ] ));
end;

procedure TMainForm.CheckCalcmem(Sender: TObject);
var
  S :TFileStream;
  C :Longint;
  M :Pointer;
  N :TFileName;
begin
  N := GetFileName;
  S := TFileStream.Create( N, fmOpenRead );
  try
    GetMem( M, S.Size );
    try
      S.read( M^, S.Size );
      C := CrcCalc.CalcMem( M, S.Size );
    finally
      FreeMem( M );
    end;
  finally
    S.free;
  end;
  memo.lines.add( format( 'CalcMem:'#09'File - %s'#09'CRC32 - %8x',
   [ ExtractFileName( N ), C ] ));
end;

procedure TMainForm.ReadDataFromStream( pData :Pointer; var cbData :Integer );
begin
  cbData := FStream.Read( pData^, cbData );
end;

procedure TMainForm.CheckCalcGen(Sender: TObject);
var
  C :Longint;
  N :TFileName;
begin
  N := GetFileName;
  FStream := TFileStream.Create( N, fmOpenRead );
  try
    CrcCalc.OnGetData := ReadDataFromStream;
    C := CrcCalc.CalcGen;
  finally
    FStream.free;
  end;
  memo.lines.add( format( 'CalcGen:'#09'File - %s'#09'CRC32 - %8x',
   [ ExtractFileName( N ), C ] ));
end;

procedure TMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

function TMainForm.GetFileName :TFileName;
begin
 with OpenDialog do
  if Execute
   then result := FileName
   else raise EAbort.Create('');
end;


end.
