{
 Author:       Craig Ward
 Copyright:    <>

 Date:         17/5/96

 Version:      1.0

 Overview:     Password change dialog.
*******************************************************************************}
unit Passw;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Cwbutton, ExtCtrls, SysUtils, dialogs, config;

type
  TPassDlg = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Bevel2: TBevel;
    cwButton1: TcwButton;
    cwButton2: TcwButton;
    procedure cwButton1Click(Sender: TObject);
    procedure cwButton2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FPasswordText: string;
  public
    { Public declarations }
  end;

var
  PassDlg: TPassDlg;

implementation

{$R *.DFM}

uses
 conini;

{***buttons********************************************************************}

{ok}
procedure TPassDlg.cwButton1Click(Sender: TObject);
begin
 if edit1.text <> '' then
  begin
   if FPasswordText = '' then FPasswordText := mEncrypt(edit1.text);
   if CompareText(mEncrypt(edit1.text),FPasswordText) = 0 then
    begin
     if edit2.text <> '' then
      begin
       if edit3.text <> '' then
        begin
         if CompareText(edit3.text,edit2.text) = 0 then
          modalResult := mrOK {passwords ok}
         else
          begin {new passwords don't match}
           messageDlg('New passwords do not match',mtWarning,[mbOK],0);
           edit2.text := '';
           edit3.text := '';
           activeControl := edit2;
          end;
        end
       else {user did not re-enter the password}
        begin
         messageDlg('You must re-enter the new password!',mtWarning,[mbOK],0);
         activeControl := edit3;
        end;
      end
     else {user did not enter a new password}
      begin
       messageDlg('You must enter a new password!',mtWarning,[mbOK],0);
       activeControl := edit2;
      end;
    end
   else {old password did not match stored password}
    begin
     messageDlg('Password does not match original password!',mtWarning,[mbOK],0);
     activeControl := edit1;
    end;
  end
 else {no changes made}
  modalResult := mrCancel;
end;

{cancel}
procedure TPassDlg.cwButton2Click(Sender: TObject);
begin
 modalResult := mrCancel;
end;


{***edits***********************************************************************}

{on change of edit1}
procedure TPassDlg.Edit1Change(Sender: TObject);
begin
 if edit1.text <> '' then
  begin
   label2.enabled := true;
   edit2.enabled := true;
  end
 else
  begin
   label2.enabled := false;
   edit2.enabled := false;
   edit2.text := '';
  end
end;

{on change of edit2}
procedure TPassDlg.Edit2Change(Sender: TObject);
begin
 if edit2.text <> '' then
  begin
   label3.enabled := true;
   edit3.enabled := true;
  end
 else
  begin
   label3.enabled := false;
   edit3.enabled := false;
   edit3.text := '';
  end
end;

{***form's preferences*********************************************************}

{on create}
procedure TPassDlg.FormCreate(Sender: TObject);
begin
 FPasswordText := ScreenSaveDialog.FPassword;
end;

end.
