unit Search;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, RHGrhBtn, RHClrBtn, RHCtrl3d, ExtCtrls,
  RHLstHdr, RHTabBox, DB, DBTables;

type
  TfrmSearch = class(TForm)
    TabListBox1: TrhTabListBox;
    TabListHeader1: TrhTabListHeader;
    btnOK: TrhButton3D;
    Table1: TTable;
    Table1LAST_NAME: TStringField;
    Table1FIRST_NAME: TStringField;
    Table1TELEPHONE: TStringField;
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure TabListBox1DblClick(Sender: TObject);
  private
    function GetCustomer: String;
  public
    property Customer: String read GetCustomer;
  end;

var
  frmSearch: TfrmSearch;

implementation

{$R *.DFM}

function TfrmSearch.GetCustomer: String;
begin
  if TabListBox1.ItemIndex >= 0 then
    Result := TabListBox1.ColText[0] + ' ' + TabListBox1.ColText[1]
  else
    Result := ''; 
end;

procedure TfrmSearch.FormCreate(Sender: TObject);
begin
  TabListBox1.Clear;
  Table1.Open;
  Table1.First;

  While (TabListBox1.Items.Count <= 50) and not (Table1.EOF) do begin
    TabListBox1.Items.Add(Table1FIRST_NAME.Value + Chr(9) +
                          Table1LAST_NAME.Value + #9 +
                          Table1TELEPHONE.Value);
    Table1.Next;
  end;

  Table1.Close;
end;

procedure TfrmSearch.btnOKClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSearch.TabListBox1DblClick(Sender: TObject);
begin
  Close;
end;

end.
