unit AlbReg;

{Albrecht Mengel, 13.9.96, mengel@stat-econ.uni-kiel.de

 USAGE:   - Just copy the file into a directory in the delphi path,
            or set the path in the project options to it.
          - Then add AlbReg to the USES list in your program.
          - There are two procedures to search and alter registry values:
            read_registry_value and modify_registry_value.
 PROBLEMS: - Not all types of Registry Variables are implemented.
             In this case occurs an error message. Please send me the
             call to the function with its parameters. I'll instantly try to
             implement it (if I find the same registry entry as you have
 Ideas (not yet implemented): - Allow wildcards in the variable
                              - Results Variables when key is proper and variable=''
 No Warranty !!!!!!!! Any use of AlbReg is on your own risk!!!!!!!!
 
 Please look in AlbReg.txt for more information!}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Registry,
  StdCtrls, Buttons;

type RootKeys = HKEY_CLASSES_ROOT..HKEY_DYN_DATA;

procedure read_registry_values(root:RootKeys; keys,variable:string; VAR conditions,result:TStringList);
{Reads Values in Registry. If variable='' then results all fitting keys}
{Root: one of HKey_Classes_Root, HKey_Current_Config, HKey_Current_User, HKey_Dyn_Data, HKey_Local_Machine, or HKey_Users
 Keys: Full path before Variable name  (example: 'enum\scsi\*\*')
       You may use * and ? as Wildcards (enum\*or* -> Enum\Network and Enum\Monitor)
 Variable: Name of Entry.              (examples: 'CurrentDriveLetterAssignment'
                                                  'AutoInsertNotification')
 Conditions: StringList of numerical/string Comparisons
             'variable=number' or 'variable<>number' or
             'variable=string' or 'variable<>string' or
             'variable=' (Test on non-existence) or
             'variable<>' (Test on existence with any value)
                                       (example: 'class=DiskDrive')
 The two StringLists must be created and detroyed by the user.
 See the following example:
     letters:=TStringList.create;
     try conditions:=TStringList.create;
     try conditions.add('class=DiskDrive');
         read_registry_values(HKey_Local_Machine,'enum\esdi\*\*','CurrentDriveLetterAssignment',
                              conditions,letters);
     // The result is line after line in the StringList letters
     with letters do
      for i:=0 to count-1 do
       memo1.lines.add('Found Disk Drive '+strings[i]+':')
     finally conditions.free end;
     finally letters.free end;
     // Now you can see your IDE drive letters in the StringList letters
     // Remark: The registry uses to hold multiple entries of drives}

procedure modify_registry_values(root:RootKeys; keys,variable,newvalue:string; conditions:TStringList);
{Looks in the registry and modifies all fitting variables to the value.
 The variable MUST exist.
 For security try first read_registry_values or the LookReg demo,
 that the correct variables are modified!}

function read_registry_value(root:RootKeys; keys,variable:string; condition:string):string;
{Similar to read_registry_values, but simpler parameters:
 Only one condition is allowed. (If no condition, use '').
 The result is only the first found value}

procedure modify_registry_value(root:RootKeys; keys,variable,newvalue:string; condition:String);
{Similar to modify_registry_values, but simpler parameters:
 Only one condition is allowed. (If no condition, use '').}

type
  TRegIniFile1 = class(TRegistry)
  private
    FFileName: string;
  public
    constructor Create(Root:RootKeys; const FileName:string);
    function ReadValue(const Section, Ident, Default: string): string;
    procedure ModifyValue(const Section, Ident, Value: String);
    property FileName:string read FFileName;
  end;

implementation

Type ERegError = class(Exception);

{Implementation of TRegIniFile1}

constructor TRegIniFile1.Create(Root:RootKeys; const FileName:string);
begin
  inherited Create;
  inherited RootKey:=Root;
  FFileName := FileName;
  OpenKey(FileName, True);
end;

function TRegIniFile1.ReadValue(const Section, Ident, Default: string): string;
{It is a combination of all original ReadXXXX functions, but tests the DataType!}
var
  Key, OldKey: HKEY;
  trick:record case byte of
        0:(len:byte; buf:Array[1..254] of char);
        1:(s:String[255]);
        end;
begin
  Key := GetKey(Section);
  if Key <> 0 then
  try
    OldKey := CurrentKey;
    SetCurrentKey(Key);
    try
      if ValueExists(Ident) then
      case GetDataType(Ident) of
        rdUnknown:raise ERegError.Create('Read: Type=Unknown. Please Email for Implementation!');
        rdString:Result:=inherited ReadString(Ident);
        rdExpandString:raise ERegError.Create('Read: Type=ExpandString. Please Email for Implementation!');
        rdInteger:result:=inttostr(inherited ReadInteger(Ident));
        rdBinary:with trick do
                 begin len:=ReadBinaryData(Ident,Buf,SizeOf(Buf));
                       result:=s;
      end        end
      else  Result := Default;
    finally
      SetCurrentKey(OldKey);
    end;
  finally
    RegCloseKey(Key);
  end
  else Result := Default;
end;

procedure TRegIniFile1.ModifyValue(const Section, Ident, Value: String);
{The Ident MUST exist, because the DataType must be read from the old Ident}
{It is a combination of all original WriteXXXX functions, but tests the DataType!}
var
  Key, OldKey: HKEY;
  trick:record case byte of
        0:(len:byte; buf:Array[1..254] of char);
        1:(s:String[255]);
        end;
begin
  Key := GetKey(Section);
  if Key=0 then raise ERegError.Create('Modify: Variable not found in Registry');
  try
    OldKey := CurrentKey;
    SetCurrentKey(Key);
    try
      if ValueExists(Ident) then
       case GetDataType(Ident) of
        rdUnknown:raise ERegError.Create('Modify: Type=Unknown. Please Email for Implementation!');
        rdString:inherited WriteString(Ident,Value);
        rdExpandString:raise ERegError.Create('Modify: Type=ExpandString. Please Email for Implementation!');
        rdInteger:inherited WriteString(Ident,Value);
        rdBinary:with trick do
                 begin s:=value;
                       inherited WriteBinaryData(Ident,Buf,len);
       end       end
    finally
      SetCurrentKey(OldKey);
    end;
  finally
    RegCloseKey(Key);
  end;
end;

{Help functions}

FUNCTION WildCard(pattern,objekt:STRING):BOOLEAN;
  VAR erg:BOOLEAN; i:INTEGER;
  BEGIN IF length(pattern)=0
          THEN IF length(objekt)=0
                  THEN WildCard:=TRUE
                  ELSE WildCard:=FALSE ELSE
        IF length(objekt)=0
          THEN IF pattern[1]='*'
                  THEN WildCard:=TRUE
                  ELSE WildCard:=FALSE ELSE
        IF pattern[1]='?'
          THEN WildCard:=WildCard(COPY(pattern,2,255),COPY(objekt,2,255)) ELSE
        IF pattern[1]='*'
          THEN BEGIN erg:=FALSE;
                     i:=1;
                     pattern:=COPY(pattern,2,255);
                     WHILE (i<=LENGTH(objekt)+1) AND NOT erg DO
                       BEGIN erg:=WildCard(pattern,COPY(objekt,i,255));
                             inc(i)
                       END;
                     WildCard:=erg;
               END
          ELSE IF pattern[1]=objekt[1]
                  THEN WildCard:=WildCard(COPY(pattern,2,255),COPY(objekt,2,255))
                  ELSE WildCard:=FALSE;
   END;{WildCard}

type act=(read_registry,write_registry);

procedure search_registry_and_do_action(root:RootKeys; keys,variable,newvalue:string; VAR conditions,result:TStringList; action:act);
var reg:TRegIniFile1;
procedure get_subkeys(key:string; var erg:TStringList);
begin reg:=TRegIniFile1.create(root,key);
      try reg.GetKeyNames(erg);
      finally reg.free;
end   end;
procedure get_variables(key:string; var erg:TStringList);
begin reg:=TRegIniFile1.create(root,key);
      try reg.GetValueNames(erg);
      finally reg.free;
end   end;
function kill_stars(x:string):string;
var s:integer;
begin repeat s:=pos('*',x);
             if s=0 then break;
             delete(x,s,1)
      until false;
      kill_stars:=x
end;
var subkey,actkey,actvar:String; p,f,s:integer;
    FullList,SubKeyList:TStringList;
    ok,not_ok:Boolean;    value:string;
begin {search_registry_and_do_action}
      FullList:=nil; {just to have the warning away}
      try SubKeyList:=TStringList.create;
      try FullList:=TStringList.create;
      FullList.add('*'); {first empty entry}
      repeat {Build all fitting full-path-keys}
        {Extract Subkey}
        p:=pos('\',keys);
        if p=0 then p:=length(keys)+1;
        subkey:=UpperCase(copy(keys,1,p-1));
        system.delete(keys,1,p);
        {Get Subkeys from every entry of the list and reduce list to fitting subkeys}
        with FullList do
        for f:=count-1 downto 0 do
        begin SubKeyList.clear;
              get_subkeys(kill_stars(strings[f]),SubKeyList);
              {Reduce the found SubKeyList to fitting subkeys}
              with SubKeyList do
               for s:=count-1 downto 0 do
                if not WildCard(subkey,UpperCase(strings[s]))
                 then delete(s);
              {Replace the entry in the FullList to a list of found Subkeys,
               expanded to full keys}
              for s:=SubKeyList.count-1 downto 0 do
               if strings[f]='*' {first entry is set to *}
                then insert(f+1,SubKeyList.strings[s])
                else insert(f+1,strings[f]+'\'+SubKeyList.strings[s]);
              delete(f);
        end;
      until keys='';
      {Now the keys should be complete}
      {Get variables from the keys}
      with FullList do
      for f:=count-1 downto 0 do
      begin {split into path and last key}
            subkey:=strings[f];
            actkey:='';
            repeat p:=pos('\',subkey);
                   if p=0 then break;
                   actkey:=actkey+'\'+copy(subkey,1,p-1);
                   system.delete(subkey,1,p)
            until false;
            system.delete(actkey,1,1);
            ok:=true; not_ok:=false;
            {Test conditions}
            reg:=TRegIniFile1.create(root,actkey);
            try with conditions do
                 for s:=0 to count-1 do
                  begin p:=pos('=',strings[s]);
                        if p>0
                        then begin actvar:=copy(strings[s],1,p-1);
                                   value:=copy(strings[s],p+1,255);
                                   if reg.ReadValue(subkey,actvar,'')<>value
                                      then ok:=false;
                             end
                        else begin p:=pos('<',strings[s]);
                                   if (p=0) or (strings[s][p+1]<>'>') then continue;
                                   actvar:=copy(strings[s],1,p-1);
                                   value:=copy(strings[s],p+2,255);
                                   if reg.ReadValue(subkey,actvar,'')=value
                                      then not_ok:=true;
                  end        end;
                if ok and not not_ok then
                  case action of
                  read_registry:if variable=''
                                then result.add(strings[f])
                                else result.add(reg.ReadValue(subkey,variable,''));
                  write_registry:reg.ModifyValue(subkey,variable,newvalue);
                  end
            finally reg.free
      end   end;
      finally FullList.free end
      finally SubKeyList.free;
end   end;

procedure read_registry_values(root:RootKeys; keys,variable:string; VAR conditions,result:TStringList);
begin search_registry_and_do_action(root,keys,variable,'',conditions,result,read_registry) end;

procedure modify_registry_values(root:RootKeys; keys,variable,newvalue:string; conditions:TStringList);
var dummy_result:TStringList;
begin if variable='' then raise ERegError.Create('Modify Value: Variable must not be empty');
      search_registry_and_do_action(root,keys,variable,newvalue,conditions,dummy_result,write_registry)
end;

function read_registry_value(root:RootKeys; keys,variable:string; condition:string):string;
var conditions,results:TStringList;
begin results:=TStringList.create;
      try conditions:=TStringList.create;
      try if condition<>'' then
            conditions.add(condition);
      read_registry_values(root,keys,variable,conditions,results);
      if results.count>0
      then read_registry_value:=results[0]
      else read_registry_value:='';
      finally conditions.free end;
      finally results.free
end   end;

procedure modify_registry_value(root:RootKeys; keys,variable,newvalue:string; condition:String);
var conditions:TStringList;
begin conditions:=TStringList.create;
      try if condition<>'' then
            conditions.add(condition);
      modify_registry_values(root,keys,variable,newvalue,conditions);
      finally conditions.free
end   end;

(***************************************************
There is no register procedure, as this unit creates
no new component! Just add AlbReg to the USES list.
***************************************************)

end.