//
// XMS.C [XMODEM Send]
//
// Requires XYDRV [ver 2.3.5 or above]
//

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wsc.h"
#include "xydrv.h"
#include "sayerror.h"

#define ONE_K  0
#define XMODEM  0

char Temp[81];

int RunXY(int Port)
{int Code;
 int Packet;
 int LastPacket;
 LastPacket = 0;
 while(1)
   {// run the driver
    Code = xyDriver(Port);
    // any messages from xyDriver ?
    while(xyGetMessage(Port,(LPSTR)Temp,80)) printf("COM%d: %s\n", 1+Port,Temp);
    if(Code == XY_IDLE) return XY_IDLE; 
    else
      {// xyDriver is running
       Packet = xyGetParameter(Port, XY_GET_PACKET);
       if(Packet != LastPacket) 
         {// show packet number
          printf(" P%1d",Packet);
          if(Packet%10==9) printf("\n");
         }
       LastPacket = Packet;
      }
   }
}

void main(int argc, char *argv[])
{int Code;
 int Port;
 int Baud;
 char *FileName; 
 printf("_______________\n");
 printf("XMS 01/09/99\n");
 if(argc != 4) 
   {printf("Usage: XMS <port> <baud> <filename>\n");
    printf("   Eg: XMS 1 19200 myfile.dat\n");
    exit(1);
   }  
 // get parameters
 Port = atoi(argv[1]) - 1;
 Baud = atoi(argv[2]);
 FileName = argv[3];
 // display parameters
 printf("Port : COM%d\n",1+Port);
 printf("Baud : %1d\n",Baud);
 printf("File : %s\n",FileName);
 printf("_______________\n");
 //reset port (8N1 is default)
 Code = SioReset(Port,1040,1040);
 if(Code < 0) 
   {SayError(Code,"SioReset");
    exit(1);
   }
 //set baud rate
 Code = SioBaud(Port,Baud);
 // set DTR & RTS 
 Code = SioDTR(Port,'S');
 Code = SioRTS(Port,'S');
 // set parms
 Code = SioParms(Port, NoParity, OneStopBit, WordLength8);
 // set RTS/CTS flow control 
 SioFlow(Port,'H');
 //acquire xyDriver;
 Code = xyAcquire(Port,Port);
 // set EOF pad to blank 
 Code = xySetParameter(Port, XY_SET_EOF_CHAR, 0x20);
 //set xyDriver debug level
 Code = xyDebug(0);
 printf("Starting XMODEM send (type Control-BREAK to quit)\n");
 Code = xyStartTx(Port, FileName, ONE_K, XMODEM);
 //run the XMODEM driver
 RunXY(Port);
 printf("\n");
 Code = xyRelease();
 Code = SioDone(Port);
}
