/* 
** echoport.c
**
** Echoes characters incoming on COM1 and COM2 using threads. 
** Compile with -MT flag.
** 
** Connect COM1 and/or COM2 to another computer using a NULL modem cable.
** Start SIMPLE on other computer(s) at 38400 baud.
** Start ECHOPORT. 
** Anything transmitted from remote is echoed back to remote by ECHOPORT.
**
** To terminate ECHOPORT, type ^C or disconnect cables (which drops DSR).
*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include "wsc.h"

#define NBR_THREADS 2

typedef struct
{int Port;
 int Running;
} ParamType;
 
void Thread(PVOID pvoid)
{int Code;
 char Chr;
 ParamType *ParamPtr;
 ParamPtr = (ParamType *) pvoid;
 /* starting thread */
 ParamPtr->Running = TRUE;
 printf("COM%d: Starting thread.\n", 1+ParamPtr->Port);
 /* reset port */
 Code = SioReset(ParamPtr->Port, 1024, 1024);
 if(Code<0)
   {/* Reset returned error */
    printf("COM%d: ERROR: %d\n", 1+ParamPtr->Port, Code);
    ParamPtr->Running = FALSE;
    return;
   }
 /* set baud rate, DTR, and RTS */
 SioBaud(ParamPtr->Port, 38400); 
 SioDTR(ParamPtr->Port, 'S');
 SioRTS(ParamPtr->Port, 'S'); 
 /* look for incoming */
 while(1)
   {/* this thread is done when DSR is dropped */
    if(SioDSR(ParamPtr->Port)==0)
       {printf("COM%d: DSR dropped, aborting thread.\n", 1+ParamPtr->Port);
        SioDone(ParamPtr->Port);
        ParamPtr->Running = FALSE;
        return;
       }
    /* get incoming */
    Code = SioGetc(ParamPtr->Port);
    if(Code<WSC_NO_DATA)
      {/* SioGetc returned error */
       printf("COM%d: ERROR %d\n", 1+ParamPtr->Port, Code);
       return;
      }
    if(Code!=WSC_NO_DATA)
      {/* good character */
       Chr = (char)Code;
       /* echo character back */
       SioPutc(ParamPtr->Port, Chr);
       /* display on screen */
       printf("%c\n",Chr);
       /* user types ^Z or ESC to quit */
       if((Chr==0x1a)||(Chr==0x1b))
         {/* user has quit */
          SioDone(ParamPtr->Port);
          ParamPtr->Running = FALSE;
          printf("COM%d: Thread terminated by remote.\n",1+ParamPtr->Port); 
          return;
         }
      } /* end if */
    /* give up rest of thread time slice */
    Sleep(0);
   } /* end while */
}

void main(int argc, char *argv[])
{int T;
 int Running;
 ParamType Params[NBR_THREADS];
 printf("ECHOPORT 1.0 (Type ^C to exit)\n");
 if(argc!=1)
   {printf("Usage: ECHOPORT\n");
    return;
   }
 /* start up each thread */
 for(T=0;T<NBR_THREADS;T++)
   {Params[T].Port = COM1 + T;
    /* start thread */
    _beginthread(Thread, 0, (void *)&Params[T]);
   }
 /* run till all threads are done */
 while(1)
   {/* check each thread */
    Running = 0;
    for(T=0;T<NBR_THREADS;T++) 
      {/* take a breather */
       Sleep(0);
       /* count running threads */
       if(Params[T].Running) Running++;
      } 
    /* all threads done ? */
    if(Running==0)
      {printf("All threads have terminated.\n");
       return;
      } 
   }
}

 
