/* console.c
**
** Windows 95/NT console application.
** Simple terminal emulator.
*/

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "wsc.h"

char Temp[80];
int Port;
int Baud;
 
/* return TRUE if user typed key */

int KeyPress(HANDLE Handle)
{DWORD NbrRead;
 INPUT_RECORD InputEvent;
 PeekConsoleInput(Handle,&InputEvent,1,&NbrRead);
 if(NbrRead==0) return FALSE;
 if( (InputEvent.EventType!=KEY_EVENT) ||
     (InputEvent.Event.KeyEvent.bKeyDown==FALSE) ||
     (InputEvent.Event.KeyEvent.uChar.AsciiChar==0) )
   {/* trash this event */
    ReadConsoleInput(Handle, &InputEvent, 1, &NbrRead);
    return FALSE;
   }
 /* character ready to read */
 return TRUE;
}

/* get input character */

char GetChar(HANDLE Handle)
{char TheChar;
 DWORD  BytesRead;
 ReadFile(Handle, &TheChar, 1, &BytesRead, 0);
 return TheChar;
}

/* write character to console */

void PutChar(HANDLE Handle, char TheChar)
{DWORD BytesWritten;
 WriteFile(Handle, &TheChar, 1, &BytesWritten, 0);
}

/* write string to console */

void PutString(HANDLE Handle, char *TheString)
{DWORD BytesWritten;
 WriteFile(Handle, TheString, strlen(TheString), &BytesWritten, 0);
}

/* trap WSC error codes */

int ErrorCheck(int Code)
{if(Code<0)
   {printf("ERROR %d ",Code);
    SioDone(Port);
    exit(1);
   }
 return Code;
}

/* display error & exit */

void SayError(char *Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i;
 HANDLE ConIn;
 HANDLE ConOut;
 DWORD OldMode;
 DWORD NewMode;
 BOOL  Success;
 /* process args */
 if(argc!=3)
   {printf("Usage: CONSOLE <port> <baud>\n");
    return;
   }
 Port = atoi(argv[1]) - 1;
 Baud = atoi(argv[2]);

 /* get handles for stdin & stdout */
 ConIn  = GetStdHandle(STD_INPUT_HANDLE);
 ConOut = GetStdHandle(STD_OUTPUT_HANDLE);
 if(ConIn==ConOut) SayError("Console Handles");
 /* modify console mode: disable line input & line echo */
 Success = GetConsoleMode(ConIn, &OldMode);
 if(!Success) SayError("GetConsoleMode");
 NewMode = OldMode & ~ENABLE_LINE_INPUT & ~ENABLE_ECHO_INPUT;
 Success = SetConsoleMode(ConIn, NewMode);
 if(!Success) SayError("SetConsoleMode");
 /* set defaults for all ports. Note 'Port' argument is -1 */
 ErrorCheck( SioReset(-1,1,1)); // DTR & RTS set at port initialization 
 ErrorCheck( SioParms(-1,NoParity,OneStopBit,WordLength8));
 /* reset (initialize) the port */
 ErrorCheck( SioReset(Port,1024,512) );
 ErrorCheck( SioBaud(Port,Baud) );
 /* DTR and RTS already set by SioReset(-1,1,1) */
   ///ErrorCheck( SioDTR(Port,'S') );
   ///ErrorCheck( SioRTS(Port,'S') );
 PutString(ConOut,"\nEnter terminal loop ( Type ^Z to exit )\n");
 /* enter terminal loop */
 while(TRUE)
   {/* was key pressed ? */
    if(KeyPress(ConIn))
      {/* fetch character */
       c = GetChar(ConIn);
       if(c==0x1a)
         {/* restore COM port status & exit */
          SioDone(Port);
          SetConsoleMode(ConIn, OldMode);
          exit(1);
         }
       else
         {/* transmit character */
          SioPutc(Port,c);
         }
      } /* end if */
    /* any incoming over serial port ? */
    i = SioGetc(Port);
    if(i>=0) PutChar(ConOut,(char)i);
   } /* end-while(TRUE) */
} /* end main */

