// textdlg.cpp : implementation file
//

#include "StdAfx.h"
#include "Vogon.h"

#include "CntrInfo.h"
#include "CntrItem.h"
#include "TextDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextRetrievalDlg dialog


CTextRetrievalDlg::CTextRetrievalDlg(_DWebster* pWebsterDispatch, CWnd* pParent /*=NULL*/)
	: CDialog(CTextRetrievalDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTextRetrievalDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

   // Stash the Webster OCX dispatch pointer
   m_pWebsterDispatch = pWebsterDispatch;
}


void CTextRetrievalDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTextRetrievalDlg)
	DDX_Control(pDX, IDC_STATIC_TITLE, m_staticTitle);
	DDX_Control(pDX, IDC_STATIC_SOURCE_BYTES, m_staticSourceBytes);
	DDX_Control(pDX, IDC_STATIC_PURE_BYTES, m_staticPureBytes);
	DDX_Control(pDX, IDC_EDIT_TEXT, m_editText);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTextRetrievalDlg, CDialog)
	//{{AFX_MSG_MAP(CTextRetrievalDlg)
	ON_BN_CLICKED(IDC_BUTTON_SOURCE, OnButtonSource)
	ON_BN_CLICKED(IDC_BUTTON_PURE, OnButtonPure)
	ON_BN_CLICKED(IDC_BUTTON_COPY, OnButtonCopy)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTextRetrievalDlg message handlers

/////////////////////////////////////////////////////////////////////////////
//
BOOL CTextRetrievalDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();

   // Show the HTML source for the current page
   UpdateFromText(FALSE);

   // TODO: Add extra initialization here

   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
//
void CTextRetrievalDlg::OnButtonSource() 
{  // Show the HTML source for the current page
   UpdateFromText(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
//
void CTextRetrievalDlg::OnButtonPure() 
{  // Show the pure text for the current page
   UpdateFromText(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
//
void CTextRetrievalDlg::OnButtonCopy() 
{  // Copy the edit box selection (or everything if no selection) to the clipboard:
   int selStart;
   int selEnd;
   
   // Stash the scroll position - select may cause scroll
   int saveLoc = m_editText.GetFirstVisibleLine();
   // Was anything selected ?
   m_editText.GetSel(selStart, selEnd);

   if (selEnd <= selStart)
   {  // No selection: select everything
      m_editText.SetSel(0, -1);
   }

   m_editText.Copy();

   if (selEnd <= selStart)
   {  // Was selected - deselect, restore to original state
      m_editText.SetSel(-1, -1);
   }

   // Restore the scroll position
   m_editText.LineScroll(saveLoc - m_editText.GetFirstVisibleLine());
}

/////////////////////////////////////////////////////////////////////////////
// CTextRetrievalDlg helper functions

/////////////////////////////////////////////////////////////////////////////
//
void CTextRetrievalDlg::UpdateFromText(BOOL bPure) 
{  // Show the source or pure text for the current page
   CString stringText;

   // Get the current page URL
   CString stringURL(m_pWebsterDispatch->GetPageURL());

   // Get the pure text length
   long pureLength   = m_pWebsterDispatch->GetTextSize(stringURL);
   // Get the source length
   long sourceLength = m_pWebsterDispatch->GetContentSizeRead(stringURL);

   // Get the text, from start to end (** 16-bit version restricted to 32KB per GetContent() **)
   if (bPure)
   {  // Pure text
      m_staticTitle.SetWindowText(CString(_T("Pure Text: ")) + stringURL);
      stringText = m_pWebsterDispatch->GetText(stringURL, 0, pureLength);
   }
   else
   {  // Source HTML text
      m_staticTitle.SetWindowText(CString(_T("Source Text: ")) + stringURL);
      stringText = m_pWebsterDispatch->GetContent(stringURL, 0, sourceLength);
   }

   // Convert all stand-alone newline characters to CR-LF for the edit control ...
   int index;
   CString stringTranslated;

   while ((index = stringText.Find(TCHAR('\n'))) >= 0)
   {  // Found an NL (== LF): translate to CR-LF
      if (index && stringText[index - 1] == TCHAR('\r'))
      {  // CR-LF present, so just use it as-is
         stringTranslated += stringText.Left(index + 1);
      }
      else
      {  // NL (== LF), no CR: translate to CR-LF
         stringTranslated += stringText.Left(index);
         stringTranslated += _T("\r\n");
      }

      // Subtract the string we just added to stringTranslated
      stringText = stringText.Mid(index + 1);
   }

   // Acquire the remaining text
   stringTranslated += stringText;


   // Display the text in the edit control:
   m_editText.SetWindowText(stringTranslated);

   // Display sizes:
   TCHAR fmtBuf[64];
   m_staticPureBytes.SetWindowText(CString(ltoa(pureLength, fmtBuf, 10)));
   m_staticSourceBytes.SetWindowText(CString(ltoa(sourceLength, fmtBuf, 10)));
}


