/* EDITFN.C */
/* v1.1 11/10/94 */
/* Example code by S Morphet TTDW, 1994 */
/* Editor functions to integrate with Steph software */


#include "d:\cwork\steph\include\steph.h"
#include "d:\cwork\steph\editor\editfn.h"
#include <stdio.h>
#include <malloc.h>
#include <string.h>


void editor_initialise( void )
{
   unsigned count;

   /* Turn cursors off for all windows, and default to csr at 0,0 */

   /* Data is stored for each window. Initialise it. */

   for( count = 0; count < __MAXWINDOWS; count++ )
   {
		_editor_spec.info[count].csr_x = 0;
      _editor_spec.info[count].csr_y = 0;
	}

	_editor_spec.sel_win = -1;

}


/* this is the keyboard filter for the editor */

void editor_filter( void )
{
   /* an editor keyboard filter function */
   char key1 = _window_spec.key1;
   char key2 = _window_spec.key2;

   if( _window_spec.key1 == 0 )
   {
      if(   (key2 == 75) || (key2 == 77) ||       /* pass cursors */
            (key2 == 72) || (key2 == 80) ||       /* PGUPDN, HOMEEND etc */
            (key2 == 79) || (key2 == 71) ||
            (key2 == 73) || (key2 == 81) ||
            (key2 == 83) || (key2 == 82) )
      {
         return;
      }
      else
      {
         _window_spec.key2 = 0;
         return;
      }
   }
   else
   {
      if( (key1 >= 32 ) && (key1 <= 126 ) )      /* pass alphanumerics */
         return;
      else
         if( ( key1 == 8 ) || ( key1 == 13 ) )   /* pass bspace and return */
            return;
         else
            _window_spec.key1 = 0;
   }
}


/* place the cursor on the screen, and set the scroll bars accordingly */
void ed_put_cursor( unsigned win )
{
   int xrange, yrange;   /* character cursor ranges */

   _s_settextposition(
         (char)(ewi.csr_y + _window[win].usetop
         - _window[win].lineo ),
         (char)( ewi.csr_x + 2 - _window[win].charo ) );

   _s_displaycursor( ON );

   xrange = CHARMAX - 78;

   yrange = _window[win].blines;
   if( yrange > 0 )
      yrange -= 1;

   _window_set_hscroll_pc( win, ( _window[win].charo * 100 / xrange   ) );

   if( yrange != 0 )  /* avoid divide by zero */
   {
      _window_set_vscroll_pc( win, ( ewi.csr_y * 100 / yrange   ) );
   }
   else
   {
      _window_set_vscroll_pc( win, 0 );
   }

   _window_drawscrollblips();
}


/* get a line from the window contents buffer */
char *get_line( unsigned win, unsigned line )
{
   if( line >= _window[win].blines )
      return NULL;

   _wb_gotoline( win, line );
   return _window[win].pwb->line;
}

/* adjust the x cursor to be within the current line */
void fix_x_cursor( void )
{
   char *templine;
   unsigned lenline;

   templine = get_line( _window_spec.active, ewi.csr_y );
   lenline = strlen( templine );

   while( ewi.csr_x > lenline )
      ewi.csr_x--;
}


/* adjust the line offset to get the cursor back on screen */
void fix_lineo( void )
{
   unsigned winsize = _window[_window_spec.active].usebottom -
         _window[_window_spec.active].usetop + 1;

   while( ewi.csr_y >= (_window[_window_spec.active].lineo + winsize ) )
      _window[_window_spec.active].lineo += 1;

   while( ewi.csr_y < _window[_window_spec.active].lineo )
      _window[_window_spec.active].lineo -= 1;
}


/* adjust the character offset to get the cursor back on screen */
void fix_charo( void )
{
   while( ewi.csr_x >= (_window[_window_spec.active].charo + 78 ) )
      _window[_window_spec.active].charo += 1;

   while( ewi.csr_x < _window[_window_spec.active].charo   )
      _window[_window_spec.active].charo -= 1;
}


/* mouse action handlers */

void editor_mouse_select( void )
{
   /* move the cursor to the click position */

	while( _mouse_nowbutton() );

   if( _window[_window_spec.active].blines != 0 )
   {
      ewi.csr_y = _window_spec.selecty + _window[_window_spec.active].lineo;

      while( ewi.csr_y >= _window[_window_spec.active].blines )
         ewi.csr_y--;

      ewi.csr_x = _window_spec.selectx + _window[_window_spec.active].charo;
      fix_x_cursor();
   }

   /* reposition the cursor */
   ed_put_cursor( _window_spec.active );

}

void editor_mouse_unselect( void )
{
   _s_displaycursor( OFF );
}

void editor_mouse_activate( void )
{
   ed_put_cursor( _window_spec.active );
}

void editor_mouse_minimise( void )
{
   fix_lineo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void editor_mouse_maximise( void )
{
   ed_put_cursor( _window_spec.active );
}

void editor_mouse_resize( void )
{
   fix_lineo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

/* scroll bar hooks */

void ems_left( void )
{
   /* move left by one char */
   if( ewi.csr_x > 0 )
      ewi.csr_x -= SMALL_SCROLL;

   fix_charo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_right( void )
{
   /* move right by one char */
   char *templine;
   templine = get_line( _window_spec.active, ewi.csr_y );

   if( ewi.csr_x < strlen( templine ) )
      ewi.csr_x += SMALL_SCROLL;

   fix_charo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_pleft( void )
{
   /* move left by a page   */
   if( ewi.csr_x >= BIG_SCROLL )
      ewi.csr_x -= BIG_SCROLL;
   else
      ewi.csr_x = 0;

   fix_charo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_pright( void )
{
   /* move right by one page */
   char *templine;
   templine = get_line( _window_spec.active, ewi.csr_y );

   ewi.csr_x += BIG_SCROLL;

	//while( ewi.csr_x > strlen( templine )	)
	//	 ewi.csr_x--;

	fix_x_cursor();

   fix_charo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_hdrag( void )
{
   /* set charo to percent of width */

   _window[_window_spec.active].charo =
         _window_spec.scrinfo * (CHARMAX - 78 ) / 100;

   ewi.csr_x = _window[_window_spec.active].charo;

   fix_x_cursor();
   fix_charo();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_up( void )
{
   /* move up by one char */
   if( ewi.csr_y > 0 )
      ewi.csr_y -= SMALL_SCROLL;

   fix_lineo();
   fix_x_cursor();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );

}

void ems_down( void )
{
   /* move down by one char */
   if( _window[_window_spec.active].blines > 0 )
      if( ewi.csr_y < (_window[_window_spec.active].blines - 1) )
         ewi.csr_y += SMALL_SCROLL;

   fix_lineo();
   fix_x_cursor();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_pup( void )
{
   /* move up by one page */
   unsigned pagesize = _window[_window_spec.active].usebottom -
         _window[_window_spec.active].usetop + 1;

   if( ewi.csr_y >= pagesize   )
      ewi.csr_y -= pagesize;
   else
      ewi.csr_y = 0;

   fix_lineo();
   fix_x_cursor();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_pdown( void )
{
   /* move down by one page */
   unsigned pagesize = _window[_window_spec.active].usebottom -
         _window[_window_spec.active].usetop + 1;

   if( _window[_window_spec.active].blines == 0 )
      return;

   ewi.csr_y += pagesize;

   while( ewi.csr_y >= _window[_window_spec.active].blines )
      ewi.csr_y--;

   fix_lineo();
   fix_x_cursor();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

void ems_vdrag( void )
{
   /* set line to percent of blines */

   if( _window[_window_spec.active].blines > 0 )
      ewi.csr_y = _window_spec.scrinfo
            * (_window[_window_spec.active].blines - 1 ) / 100;

   fix_lineo();
   fix_x_cursor();
   _window_refresh( _window_spec.active );
   ed_put_cursor( _window_spec.active );
}

/* keyboard functions */

/* put a character in */
void _ed_char_ins( int *cxp, int *cyp, char the_char   )
{
   int count;
   char *templine;

   templine = get_line( _window_spec.active, *cyp );

   /* impose character limit */
   if( strlen( templine ) == CHARMAX )
   {
      printf("\a");
      return;
   }

   /* insert mode? */
   if( (((_s_shift_key_read( ) & 0x0080 ) ? -1 : 0)) || (*cxp == strlen(templine) ) )
   {
      /* make space to insert into */
		templine = _s_realloc( templine, (strlen( templine ) + 2) );
      if( templine == NULL )
			return;

      /* shift up to make space at cursor */
      for( count = strlen(templine); count >= *cxp; count-- )
         *(templine+count+1) = *(templine+count);
   }

   /* insert at cursor, or overwrite */
   *( templine + *cxp ) = the_char;

   /* save the text and move the cursor */
   _wb_settext( _window_spec.active, templine );
   (*cxp)++;
}

void _ed_delete_fwd( int *cxp, int *cyp   )
{
   int count;
   char *templine;

   templine = get_line( _window_spec.active, *cyp );

   if( *cxp == ( strlen(templine) ) )
   {
      templine = get_line( _window_spec.active, (*cyp + 1)   );

      if( templine == NULL )
         return;

      (*cyp)++;
      (*cxp) = 0;
   }

   /* delete in the line */

   for( count = *cxp; count < strlen( templine ); count++ )
      *(templine+count) = *(templine+1+count);

	templine = _s_realloc( templine, (strlen( templine ) + 1) );
   if( templine == NULL )
		return;

   _wb_settext( _window_spec.active, templine );
}

void _ed_backspace( int *cxp, int *cyp   )
{
   int count;
   char ec_store;
   char *newline;
   char *templine;

   templine = get_line( _window_spec.active, *cyp );

   if( *cxp != 0 )
   {
      /* delete in the line */

      for( count = (*cxp - 1); count < strlen( templine ); count++ )
         *(templine+count) = *(templine+1+count);

		templine = _s_realloc( templine, (strlen( templine ) + 1) );
      if( templine == NULL )
			return;

      _wb_settext( _window_spec.active, templine );
      (*cxp)--;
   }
   else
   {
      /* delete back to previous line */
      /* if previous line is an endpara then combine two lines,
         otherwise, move to previous line and delete last char
      */

      ec_store = _wb_getend( _window_spec.active );
      newline = get_line( _window_spec.active, (*cyp - 1) );

      if( _wb_getend( _window_spec.active ) == ENDPARA )
      {
         /* combine lines */

         *cxp = strlen( newline );

         /* need more space... */
			newline = _s_realloc( newline,
            ( strlen(newline) + strlen(templine) + 1 ) );
         if( newline == NULL )
				return;

         newline = strcat( newline, templine );
         _wb_settext( _window_spec.active, newline );
         _wb_setend( _window_spec.active, ec_store );

         /* delete the old line */
         _wb_gotoline( _window_spec.active, *cyp );
         _wb_delline( _window_spec.active );

			(*cyp)--;

      }
      else
      {
         (*cyp)--;

         templine = get_line( _window_spec.active, *cyp );
         *(templine + strlen( templine ) - 1 ) = 0;
			templine = _s_realloc( templine, (strlen( templine ) + 1) );
			if( templine == NULL )
				return;

         _wb_settext( _window_spec.active, templine );
         *cxp = strlen( newline );

		}
   }
}

void _ed_return( int *cxp, int *cyp   )
{
   char *newline;
   char *templine;

   int count;
   char ec_store;

   templine = get_line( _window_spec.active, *cyp );

   /* need to split line if not at the end */
	if( *cxp == ( strlen(templine) /*+ 1*/ ) )
   {
      /* start an ordinary new line */
      /* terminate the current line with an endpara */
      _wb_setend( _window_spec.active, ENDPARA );

      /* newline, empty it, and move to it */
      _wb_newline( _window_spec.active );
		_wb_settext( _window_spec.active, _s_strdup("") );
      _wb_setend( _window_spec.active, ENDPARA );

   }
   else
   {
      /* get the end type which will now apply to the new line...*/
      ec_store = _wb_getend( _window_spec.active );

      /* split this line into a new one. */
      _wb_newline( _window_spec.active );

      /* allocate for the new line */
		newline = _s_malloc( (size_t)(strlen(templine) - *cxp + 1 ) );
      if( newline == NULL )
			return;

      /* copy string into the new buffer */
      for( count = 0; count < ( strlen(templine) - *cxp + 1 ); count++ )
         *(newline + count) = *(templine + count + *cxp );

      *(templine + *cxp) = 0;

      /* reallocate the old buffer to size it down */
		templine = _s_realloc( templine, (size_t)( *cxp + 1 ) );
      if( templine == NULL )
			return;

      /* store lines */
      _wb_gotoline( _window_spec.active, *cyp );
      _wb_settext( _window_spec.active, templine );
      _wb_setend( _window_spec.active, ENDPARA );

      _wb_gotoline( _window_spec.active, *cyp + 1 );
      _wb_settext( _window_spec.active, newline );
      _wb_setend( _window_spec.active, ec_store );
   }

   *cyp = * cyp + 1;
	*cxp = 0;
}

void _ed_home( int *cxp,  int *cyp )
{
   *cxp = 0;
}

void _ed_end( int *cxp,   int *cyp )
{
   char *templine;
   templine = get_line( _window_spec.active, *cyp );
   *cxp = strlen( templine );
}

void _ed_insert( void )
{
   _s_settextcursor( ((_s_shift_key_read( ) & 0x0080 ) ? -1 : 0)?
         _steph_spec.cursor:_steph_spec.otcursor );
}

void _ed_cursor_left( int *cxp, int *cyp   )
{
   *cxp = *cxp - 1;

   if(*cxp < 0)
   {
      if( *cyp == 0 )
         *cxp = *cxp + 1;
      else
      {
         *cyp = *cyp - 1;
         _ed_end( cxp, cyp );
      }
   }
}

void _ed_cursor_right( int *cxp, int *cyp   )
{
   char *templine;

   templine = get_line( _window_spec.active, *cyp );
   *cxp = *cxp + 1;

   if( *cxp > strlen(templine))
   {
      if( *cyp == (_window[_window_spec.active].blines - 1) )
         *cxp = strlen(templine);
      else
      {
         *cxp = 0;
         *cyp = *cyp + 1;
      }
   }
}

void _ed_cursor_up( int *cxp, int *cyp )
{
   char *templine;

   if( *cyp > 0 )
      *cyp = *cyp - 1;

   templine = get_line( _window_spec.active, *cyp );

   if( *cxp > strlen( templine ) )
      *cxp = strlen( templine );
}

void _ed_cursor_down( int *cxp, int *cyp )
{
   char *templine;

   if( *cyp < ( _window[_window_spec.active].blines - 1 ) )
      *cyp = *cyp + 1;

   templine = get_line( _window_spec.active, *cyp );

   if( *cxp > strlen( templine ) )
      *cxp = strlen( templine );
}

void _ed_pg_up( int *cxp, int *cyp )
{
   unsigned pagesize = _window[_window_spec.active].usebottom -
         _window[_window_spec.active].usetop + 1;

   char *templine;

   if( *cyp >= pagesize )
      *cyp = *cyp - pagesize;
   else
      *cyp = 0;

   templine = get_line( _window_spec.active, *cyp );

   if( *cxp > strlen( templine ) )
      *cxp = strlen( templine );
}

void _ed_pg_down( int *cxp, int *cyp )
{
   unsigned pagesize = _window[_window_spec.active].usebottom -
         _window[_window_spec.active].usetop + 1;

   char *templine;

   if( _window[_window_spec.active].blines == 0 )
      return;

   if( (*cyp+pagesize) <= ( _window[_window_spec.active].blines - 1 ) )
      *cyp = *cyp + pagesize;
   else
      *cyp = _window[_window_spec.active].blines - 1;

   templine = get_line( _window_spec.active, *cyp );

   if( *cxp > strlen( templine ) )
      *cxp = strlen( templine );
}


/* the editor action function */

void editor_action( void )
{
   char redraw = FALSE;    /* do we need to redraw window? TRUE = YES */

   int cx, cy;             /* working cursor position variables */

   unsigned char key1= _window_spec.key1;
   unsigned char key2= _window_spec.key2;

   unsigned winsize = _window[_window_spec.active].usebottom -
         _window[_window_spec.active].usetop + 1;

   cy = ewi.csr_y;
   cx = ewi.csr_x;

   /* there are sometimes big keyboard repeats, eg in delete, so soak up
      excess keystrokes
   */
   _s_flush_keyboard();


   /* if the window has no buffer lines, then create the zeroth one */
   if( _window[_window_spec.active].blines == 0 )
   {
      _wb_newline( _window_spec.active );

      /* all wb texts must be dynamic... */
		_wb_settext( _window_spec.active, _s_strdup( "" ) );

      /* it must be the end of the document... */
      _wb_setend( _window_spec.active, ENDDOC );
   }

   /* insert the character and advance the cursor */
   if( ( key1 >= 32 ) && ( key1 <= 126 ) )
   {
      _ed_char_ins( &cx, &cy, key1 );
      redraw = TRUE;
   }
   else

   /* backspace */
   if( ( key1 == 8 ) && ( (cy > 0) || (cx > 0) ) )
   {
      _ed_backspace( &cx, &cy );
      redraw = TRUE;
   }
   else

   /* delete */
   if( key2 == 83 )
   {
      _ed_delete_fwd( &cx, &cy );
      redraw = TRUE;
   }
   else

   /* insert (overtype toggle) */
   if( key2 == 82 )
   {
      _ed_insert();
   }
   else

   /* return key pressed */
   if( key1 == 13 )
   {
      _ed_return( &cx, &cy );
      redraw = TRUE;
   }
   else

   /* cursor left */
   if( key2 == 75 )
   {
      _ed_cursor_left( &cx, &cy );
   }
   else

   /* cursor right */
   if( key2 == 77 )
   {
      _ed_cursor_right( &cx, &cy   );
   }
   else

   /* cursor up */
   if( key2 == 72 )
   {
      _ed_cursor_up( &cx, &cy );
   }
   else

   /* cursor down */
   if( key2 == 80 )
   {
      _ed_cursor_down( &cx, &cy );
   }
   else

   /* home */
   if( key2 == 71 )
   {
      _ed_home( &cx, &cy );
   }
   else

   /* end */
   if( key2 == 79 )
   {
      _ed_end( &cx, &cy );
   }
   else

   /* pgup */
   if( key2 == 73 )
   {
      _ed_pg_up( &cx, &cy );
   }
   else

   /* pgdn */
   if( key2 == 81 )
   {
      _ed_pg_down( &cx, &cy );
   }


   /* check that cursor is in screen and scroll otherwise */

   while( cx < _window[_window_spec.active].charo)
   {
      _window[_window_spec.active].charo -= SMALL_SCROLL;
      redraw = TRUE;
   }

   while( cx > (_window[_window_spec.active].charo + 77) )
   {
      _window[_window_spec.active].charo += SMALL_SCROLL;
      redraw = TRUE;
   }

   while( cy < _window[_window_spec.active].lineo)
   {
      _window[_window_spec.active].lineo -= SMALL_SCROLL;
      redraw = TRUE;
   }

   while( cy >= (_window[_window_spec.active].lineo + winsize ) )
   {
      _window[_window_spec.active].lineo += SMALL_SCROLL;
      redraw = TRUE;
   }


   /* refresh */
   if( redraw )
      _window_refresh( _window_spec.active );

   ewi.csr_x = cx;
   ewi.csr_y = cy;

	ed_put_cursor( _window_spec.active );



}





/**********************************************************************/

/* function to turn an editor window buffer set into
	a buffer with \n to delimit lines */

char *_ed_makebuffer( unsigned win )
{
	/* count through lines, adding each to the buffer */

	char *buffer;
	char *thisline;

	unsigned slen = 0;
	unsigned savelen = 0;

	unsigned linenum = 0;
	unsigned count;

	buffer = _s_malloc( 0 );
	if( buffer == NULL )
		return NULL;


	do
	{
		_wbcc_uncolour( win, linenum );
		thisline = get_line( win, linenum );

		slen += 1 + strlen( thisline );

		/* reallocate the buffer */

		buffer = _s_realloc( buffer, slen );
		if( buffer == NULL )
			return NULL;

		/* copy the string into the buffer */

		for( count = savelen; count < (slen	- 1); count++ )
			*(buffer+count) = *(thisline+count-savelen);
		*(buffer+slen-1) = '\n';

		savelen = slen;

		linenum += 1;
	}while( _window[win].pwb->link != NULL );

	/* done all lines */

	*(buffer+savelen) = '\0';

	return buffer;
}

/******************************************************/


int _ed_readfile( unsigned win, char *fname )
{
	/* load a file from disk */

	FILE *infile;
	unsigned line;
	char tmp[CHARMAX+1];
	unsigned readlen;

	/* open the file */

	infile = fopen( fname, "rt" );

	if( infile == NULL ) return FALSE;

	/* file opened ok */

	/* empty the window buffer */

	while( _window[win].blines > 0 )
		_wb_delline( win );

	while(1)
	{
		/* read a line until end or error */

		if( fgets( tmp, CHARMAX, infile ) == NULL )
			break;
			/* might be EOF or error */

		/* store in window buffer after removing the newline */

		readlen = strlen(tmp);

		if( *(tmp+readlen-1) == 0x0a )
			*(tmp+readlen-1) = '\0';

		_wb_newline( win );
		_wb_settext( win, _s_strdup(tmp) );
	}

	/* done */

	fclose( infile );

	return TRUE;
}
