#include <windows.h>
#include "gui.h"

static char szClassName[] = "GUI";

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static char mytext[] =
    "GNU C/C++ opens the World of 32-bit Windows Programming!";
    PAINTSTRUCT ps;

    switch (message)
    {
        case WM_PAINT:
            BeginPaint(hWnd, &ps);
            TextOut(ps.hdc, 10, 10, mytext, sizeof(mytext) - 1);
            EndPaint(hWnd, &ps);
            return 0;

        case WM_COMMAND:
            switch (LOWORD(wParam))
            {
                case IDM_EXIT:
                    SendMessage(hWnd, WM_CLOSE, 0, 0L);
                    return 0;

                case IDM_ABOUT:
                    MessageBox(hWnd,
                        "(c) Copyright 1996 Rainer Schnitker",
                        "Hello Win32 world", MB_OK);
                    return 0;
            }
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            return 0;

    }

    return DefWindowProc(hWnd, message, wParam, lParam);
}

BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS wc;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = "MAIN_MENU";
    wc.lpszClassName = szClassName;

    return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    HWND hWindow;

    hWindow = CreateWindow(
        szClassName,
        "RSXNT for djgpp Gnu C/C++ port - (c) Rainer Schnitker",
	WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
	NULL, NULL,
	hInstance,
	NULL);

    if (!hWindow)
        return FALSE;

    ShowWindow(hWindow, nCmdShow);
    UpdateWindow(hWindow);

    return TRUE;
}

int WINAPI WinMain (
    HINSTANCE hInstance,
    HINSTANCE hPrevInst,
    LPSTR lpszCmdParam,
    int nCmdShow)
{
    MSG msg;

    if (!InitApplication(hInstance)) {
        MessageBox(NULL, "register class", NULL, MB_OK);
	return (FALSE);
    }
    if (!InitInstance(hInstance, nCmdShow)) {
        MessageBox(NULL, "create window", NULL, MB_OK);
	return (FALSE);
    }

    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }

    return msg.wParam;
}
