#ifndef _H_H
#define _H_H

/*
 *	Include header for make
 */
#ifdef WIN32
 #include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

typedef unsigned long time_t;
typedef unsigned char uchar;
typedef unsigned char bool;

#define DEFN1		"makefile"		/*  Default names  */

#define LZ		(1024)			/*  Line size  */

/*
 *	A name.  This represents a file, either to be made, or existant
 */

typedef struct name
{
  struct name *	n_next;		/* Next in the list of names */
  char *	n_name;		/* Called */
  struct line *	n_line;		/* Dependencies */
  time_t	n_time;		/* Modify time of this name */
  uchar		n_flag;		/* Info about the name */
} NAME;

#define N_MARK		0x01			/* For cycle check */
#define N_DONE		0x02			/* Name looked at */
#define N_TARG		0x04			/* Name is a target */
#define N_PREC		0x08			/* Target is precious */
#define N_DOUBLE	0x10			/* Double colon target */

/*
 *	Definition of a target line.
 */
typedef struct	line
{
  struct line *l_next;		/* Next line (for ::) */
  struct depend *l_dep;		/* Dependents for this line */
  struct cmd *l_cmd;		/* Commands for this line */
} LINE;


/*
 *	List of dependents for a line
 */
typedef struct	depend
{
  struct depend *d_next;		/* Next dependent */
  struct name *d_name;		/* Name of dependent */
} DEPEND;


/*
 *	Commands for a line
 */
typedef struct	cmd
{
  struct cmd *c_next;		/* Next command line */
  char       *c_cmd;		/* Command line */
} CMD;


/*
 *	Macro storage
 */
typedef struct	macro
{
  struct macro *m_next;		/* Next variable */
  char *	m_name;		/* Called ... */
  char *	m_val;		/* Its value */
  uchar		m_flag;		/* Infinite loop check */
} MACRO;


// My definitions

void fatal(const char *,...);

// Inherited definitions

extern char *	myname;
extern NAME	namehead;
extern MACRO *	macrohead;
extern NAME *	firstname;
extern bool	silent;
extern bool	ignore;
extern bool	rules;
extern bool	dotouch;
extern bool	quest;
extern bool	domake;
extern char	str1[];
extern char	str2[];
extern int	lineno;

char *		getmacro();
MACRO *		setmacro();
void		input();
void		error();
int		make();
NAME *		newname();
DEPEND *	newdep();
CMD *		newcmd();
void		newline();
char *		suffix();
void		touch();
void		makerules();
char *		gettok();
void		precious();
#endif
