
#define S_COMPILE	0x1
#define S_REGISTER  0x2
#define S_UDT       0x4
#define S_START     0x5
#define S_END       0x6
#define S_OBJNAME   0x9
#define S_BPREL32	0x200
#define S_LDATA32	0x201
#define S_GDATA32	0x202
#define S_GPROC32	0x205
#define S_LPROC32	0x204
#define S_BLOCK32	0x207
#define S_LABEL32	0x209
#define S_PROCREF   0x400
#define S_DATAREF   0x401

struct procInfo {
	long pParent;
	long pEnd;
	long pNext;
	long procLength;
	long debugStart;
	long debugEnd;
	long offset;
	short segment;
	short procType;
	char flags;
	union {
		char fname[4];
		char *Name;
	} u;
};

struct blockInfo {
	long pParent;
	long pEnd;
	long length;
	long offset;
	short segment;
	char name[1];
};
struct localDataInfo {
	long offset;
	short segment;
	short type;
	char name[1];
};
/*
(0x0200) BP Relative 16:32
This symbol specifies symbols that are allocated on the stack for a procedure.
For C/C++, these include the actual parameters to a function and the local 
nonstatic variables of functions.
  
2		2			4		2		*

length	S_BPREL32	offset	@type	name

offset	Signed offset relative to BP.  If offset  is 0, then the symbol was 
		assigned to a register or never instantiated by the optimizer and cannot 
		be evaluated because its location is unknown.
@type 	Type of the symbol
name	Length-prefixed name of the symbol
*/
#define S_BPREL32	0x200
struct autoDataInfo {
	long offset;	/* offset from BP */
	short type;
	char name[1];
};

struct UDT {	/* User Defined Type */
	short type;
	char name[1];
};

struct codeLabel {
	long offset;
	short segment;
	char flags;
	char name[1];
};

/* All values not defined are reserved for future use.*/
#define sstModule	0x120
#define sstTypes	0x121
#define sstPublic	0x122
#define sstPublicSym	0x123
#define sstSymbols	0x124
#define sstAlignSym	0x125
#define sstSrcLnSeg	0x126
#define sstSrcModule	0x127
#define sstLibraries	0x128
#define sstGlobalSym	0x129
#define sstGlobalPub	0x12a
#define sstGlobalTypes	0x12b
#define sstMPC	0x12c
#define sstSegMap	0x12d
#define sstSegName	0x12e
#define sstPreComp	0x12f
/* unused	0x130 */
#define sstOffsetMap16	0x131
#define sstOffsetMap32	0x132
#define sstFileIndex	0x133
#define sstStaticSym	0x134

#if 0
#define FRAME_FPO 0
#define FRAME_TRAP 1
#define FRAME_TSS 2
typedef struct _FOP_DATA {
	DWORD ulOffStart; /* Start of the function */
	DWORD cbProcSize; /* size of the function */
	DWORD Locals;	  /* Number of bytes in locals */
	WORD  Params;     /* Number of bytes in params */
	WORD  cbProlog:8; /* Number of bytes of prologue code */
	WORD  cbRegs  :3; /* Number of registers saved */
	WORD  fHasSEH :1; /* True if SEH (?) in function */
	WORD  fUseBP  :1; /* True if ebp has been allocated */
	WORD  reserved:1;
	WORD  cbFrame :2; /* frame type */
}FPO_DATA;
#endif
typedef struct tagDataList {
	struct tagDataList *Next;
	int len;
	char *data;
	char *Name;
	short Typeidx;
} DataList;
typedef struct tagProcList {
	struct tagProcList *Next;
	struct procInfo procInfo;
	int len;
	char *data;
	DataList *FunctionRecord;
	unsigned short NrOfArguments;
	Symbol Sym;
} ProcList;

#define LF_POINTER   0x2
#define LF_STRUCTURE 0x5
#define LF_UNION     0x6
#define LF_PROCEDURE 0x8
#define LF_ARGLIST   0x201
#define LF_LIST      0x204
#define LF_MEMBER    0x406
#define LF_LONG      0x8003
#define LF_ARRAY     0x3
typedef struct tagStructType {
	unsigned short len;
	unsigned short tag;
	unsigned short count;
	unsigned short fieldtype;
	unsigned short property;
	unsigned short derived;
	unsigned short vshape;
	unsigned short bytes;
	char name[1];
} StructType;

extern DataList *DataSymbolsInfo;
extern DataList *DataTypesInfo;
extern ProcList *ProceduresList;
char *PutLengthPrefixedName(char *dst,char *src);
DataList *AddToCVData(char *data,int len,char *name);



