%{
enum { EAX=0, ECX=1, EDX=2, EBX=3, ESI=6, EDI=7 };
#include "c.h"
#define NODEPTR_TYPE Node
#define OP_LABEL(p) ((p)->op)
#define LEFT_CHILD(p) ((p)->kids[0])
#define RIGHT_CHILD(p) ((p)->kids[1])
#define STATE_LABEL(p) ((p)->x.state)
static void address     ARGS((Symbol, Symbol, int));
static void blkfetch    ARGS((int, int, int, int));
static void blkloop     ARGS((int, int, int, int, int, int[]));
static void blkstore    ARGS((int, int, int, int));
static int  ckstack     ARGS((Node, int));
static void defaddress  ARGS((Symbol));
static void defconst    ARGS((int, Value));
static void defstring   ARGS((int, char *));
static void defsymbol   ARGS((Symbol));
static void doarg       ARGS((Node));
static void emit0       ARGS((Node));
static void emit2       ARGS((Node));
static void export      ARGS((Symbol));
static void clobber     ARGS((Node));
static void function    ARGS((Symbol, Symbol [], Symbol [], int));
static void global      ARGS((Symbol));
static void import      ARGS((Symbol));
static void local       ARGS((Symbol));
static void progbeg     ARGS((int, char **));
static void progend     ARGS((void));
static void segment     ARGS((int));
static void space       ARGS((int));
static void target      ARGS((Node));
static int memop ARGS((Node));
static int hasargs ARGS((Node));
#ifndef ASM_LIB
static int sametree ARGS((Node, Node));
#else
extern int sametree ARGS((Node,Node));
#endif
static int iscon16(Node);
static int immediateOpShort(Node);
static int iszero(Node);
static int iscon8(Node);
static int incrmem(Node);
Symbol charreg[32], shortreg[32], intreg[32];
static Symbol fltreg[32];
int cseg;
static int dequal(Node,int);
static int fequal(Node,int);
static Symbol quo, rem;

%}
%start stmt
%term ADDD=306 ADDF=305 ADDI=309 ADDP=311 ADDU=310
%term ADDRFP=279
%term ADDRGP=263
%term ADDRLP=295
%term ARGB=41 ARGD=34 ARGF=33 ARGI=37 ARGP=39
%term ASGNB=57 ASGNC=51 ASGND=50 ASGNF=49 ASGNI=53 ASGNP=55 ASGNS=52
%term BANDU=390
%term BCOMU=406
%term BORU=422
%term BXORU=438
%term CALLB=217 CALLD=210 CALLF=209 CALLI=213 CALLV=216
%term CNSTC=19 CNSTD=18 CNSTF=17 CNSTI=21 CNSTP=23 CNSTS=20 CNSTU=22
%term CVCI=85 CVCU=86
%term CVDF=97 CVDI=101
%term CVFD=114
%term CVIC=131 CVID=130 CVIS=132 CVIU=134
%term CVPU=150
%term CVSI=165 CVSU=166
%term CVUC=179 CVUI=181 CVUP=183 CVUS=180
%term DIVD=450 DIVF=449 DIVI=453 DIVU=454
%term EQD=482 EQF=481 EQI=485
%term GED=498 GEF=497 GEI=501 GEU=502
%term GTD=514 GTF=513 GTI=517 GTU=518
%term INDIRB=73 INDIRC=67 INDIRD=66 INDIRF=65 INDIRI=69 INDIRP=71 INDIRS=68
%term JUMPV=584
%term LABELV=600
%term LED=530 LEF=529 LEI=533 LEU=534
%term LOADB=233 LOADC=227 LOADD=226 LOADF=225 LOADI=229 LOADP=231 LOADS=228 LOADU=230
%term LSHI=341 LSHU=342
%term LTD=546 LTF=545 LTI=549 LTU=550
%term MODI=357 MODU=358
%term MULD=466 MULF=465 MULI=469 MULU=470
%term NED=562 NEF=561 NEI=565
%term NEGD=194 NEGF=193 NEGI=197
%term RETD=242 RETF=241 RETI=245
%term RSHI=373 RSHU=374
%term SUBD=322 SUBF=321 SUBI=325 SUBP=327 SUBU=326
%term BOOLEANVAL=613
%term VREGP=615
%%

reg: INDIRC(VREGP)	"# read register\n"
reg: INDIRI(VREGP)	"# read register\n"
reg: INDIRP(VREGP)	"# read register\n"
reg: INDIRS(VREGP)	"# read register\n"
freg: INDIRD(VREGP)	"# read register\n"
freg: INDIRF(VREGP)	"# read register\n"
stmt: ASGNC(VREGP,reg)	"# write register\n"
stmt: ASGNI(VREGP,reg)	"# write register\n"
stmt: ASGNP(VREGP,reg)	"# write register\n"

stmt: ASGNS(VREGP,reg)	"# write register\n"
stmt: ASGND(VREGP,freg)	"# write register\n"
stmt: ASGNF(VREGP,freg)	"# write register\n"
con: CNSTC	"$%a"
con: CNSTI	"$%a"
con: CNSTP	"$%a"
con: CNSTS	"$%a"
con: CNSTU	"$%a"
stmt: reg	""
stmt: freg	""
reg: CVIU(reg)  "%0"  notarget(a)
reg: CVPU(reg)  "%0"  notarget(a)
reg: CVUI(reg)  "%0"  notarget(a)
reg: CVUP(reg)  "%0"  notarget(a)

acon: ADDRGP	"%a"
acon: CNSTC	"%a"
acon: CNSTI	"%a"
acon: CNSTP	"%a"
acon: CNSTS	"%a"
acon: CNSTU	"%a"

baseaddr: ADDRGP	"%a"
base: reg   	    	"(%0)"
base: ADDI(reg,acon)	"%1(%0)"
base: ADDP(reg,acon)	"%1(%0)"
base: ADDU(reg,acon)	"%1(%0)"
base: ADDRFP		"%a(%%ebp)"
base: ADDRLP		"%a(%%ebp)"

con1: CNSTI	"1"	range(a, 1, 1)
con1: CNSTU	"1"	range(a, 1, 1)

icon: CNSTI	"2"	range(a, 1, 1)
icon: CNSTU	"2"	range(a, 1, 1)
icon: CNSTI	"4"	range(a, 2, 2)
icon: CNSTU	"4"	range(a, 2, 2)
icon: CNSTI	"8"	range(a, 3, 3)
icon: CNSTU	"8"	range(a, 3, 3)

index: reg              "%0"
index: LSHI(reg,icon)	"%0,%1"
index: LSHU(reg,icon)	"%0,%1"

addr: base			"%0" 1
addr: baseaddr			"%0"
addr: ADDI(index,baseaddr)	"%1(,%0)"
addr: ADDI(reg,baseaddr)	"%1(%0)"
addr: ADDI(index,reg)		"(%1,%0)"

addr: ADDP(index,baseaddr)	"%1(,%0)"
addr: ADDP(reg,baseaddr)	"%1(%0)"
addr: ADDP(index,reg)		"(%1,%0)"
addr: ADDU(index,baseaddr)	"%1(,%0)"
addr: ADDU(reg,baseaddr)	"%1(%0)"
addr: ADDU(index,reg)		"(%1,%0)"

addr: index			"(,%0)"

memb: INDIRC(addr)	"%0"
memw: INDIRS(addr)	"%0"
mem:  INDIRI(addr)	"%0"
mem:  INDIRP(addr)	"%0"

rc5: CNSTI	"$%a"	range(a, 0, 31)
rc5: reg	"%%cl"

rc: reg		"%0"
rc: con		"%0"

mr:   reg  "%0"
mr:   mem  "%0"

mrb:   reg  "%0"
mrb:   memb  "%0"

mrw:   reg  "%0"
mrw:   memw  "%0"

mrc: mem  "%0"  1
mrc: memb  "%0"  1
mrc: memw  "%0"  1
mrc: rc   "%0"

reg: addr		"\tleal\t%0,%c\n"			1
reg: mr			"\tmovl\t%0,%c\n"			1
reg: mrb		"\tmovb\t%0,%c\n"			1
reg: mrw		"\tmovw\t%0,%c\n"			1
reg: con		"\tmovl\t%0,%c\n"			1
reg: LOADC(reg)		"\tmovb\t%0,%c\n"			move(a)
reg: LOADI(reg)		"\tmovl\t%0,%c\n"			move(a)
reg: LOADP(reg)		"\tmovl\t%0,%c\n"			move(a)
reg: LOADS(reg)		"\tmovw\t%0,%c\n"			move(a)
reg: LOADU(reg)		"\tmovl\t%0,%c\n"			move(a)
reg: ADDI(reg,mrc)	"?\tmovl\t%0,%c\n\taddl\t%1,%c\n"	1
reg: ADDP(reg,mrc)	"?\tmovl\t%0,%c\n\taddl\t%1,%c\n"	1
reg: ADDU(reg,mrc)	"?\tmovl\t%0,%c\n\taddl\t%1,%c\n"	1
reg: SUBI(reg,mrc)	"?\tmovl\t%0,%c\n\tsubl\t%1,%c\n"	1	
reg: SUBP(reg,mrc)	"?\tmovl\t%0,%c\n\tsubl\t%1,%c\n"	1
reg: SUBU(reg,mrc)	"?\tmovl\t%0,%c\n\tsubl\t%1,%c\n"	1
reg: BANDU(reg,mrc)	"?\tmovl\t%0,%c\n\tandl\t%1,%c\n"	1
reg: BORU(reg,mrc)	"?\tmovl\t%0,%c\n\torl\t%1,%c\n"	1

reg: BXORU(reg,mrc)	"?\tmovl\t%0,%c\n\txorl\t%1,%c\n"	1
reg: LSHI(reg,rc5)	"?\tmovl\t%0,%c\n\tsall\t%1,%c\n"	2
reg: LSHU(reg,rc5)	"?\tmovl\t%0,%c\n\tshll\t%1,%c\n"	2
reg: RSHI(reg,rc5)	"?\tmovl\t%0,%c\n\tsarl\t%1,%c\n"	2
reg: RSHU(reg,rc5)	"?\tmovl\t%0,%c\n\tshrl\t%1,%c\n"	2
reg: BCOMU(reg)		"?\tmovl\t%0,%c\n\tnotl\t%c\n"		2
reg: NEGI(reg)		"?\tmovl\t%0,%c\n\tnegl\t%c\n"		2

stmt: ASGNI(addr,ADDI(mem,con1)) "\tincl\t%1\n"		memop(a)
stmt: ASGNI(addr,ADDU(mem,con1)) "\tincl\t%1\n"		memop(a)
stmt: ASGNP(addr,ADDP(mem,con1)) "\tincl\t%1\n"		memop(a)
stmt: ASGNI(addr,SUBI(mem,con1)) "\tdecl\t%1\n"		memop(a)
stmt: ASGNI(addr,SUBU(mem,con1)) "\tdecl\t%1\n"		memop(a)
stmt: ASGNP(addr,SUBP(mem,con1))"\tdecl\t%1\n"		memop(a)
stmt: ASGNI(addr,ADDI(mem,rc))	"\taddl\t%2,%1\n"	memop(a)

stmt: ASGNI(addr,ADDU(mem,rc))	"\taddl\t%2,%1\n" 	memop(a)
stmt: ASGNI(addr,SUBI(mem,rc))	"\tsubl\t%2,%1\n"	memop(a)
stmt: ASGNI(addr,SUBU(mem,rc))	"\tsubl\t%2,%1\n"	memop(a)
stmt: ASGNI(addr,BANDU(mem,rc))	"\tandl\t%2,%1\n"  	memop(a)
stmt: ASGNI(addr,BORU(mem,rc))	"\torl\t%2,%1\n"	1+memop(a)

stmt: ASGNI(addr,BXORU(mem,rc))	"\txorl\t%2,%1\n" 	memop(a)
stmt: ASGNI(addr,BCOMU(mem))	"\tnotl\t%1\n"		memop(a)
stmt: ASGNI(addr,NEGI(mem))	"\tnegl\t%1\n"  	memop(a)
stmt: ASGNI(addr,LSHI(mem,rc5))	"\tsall\t%2,%1\n"	memop(a)
stmt: ASGNI(addr,LSHU(mem,rc5))	"\tshll\t%2,%1\n"	memop(a)
stmt: ASGNI(addr,RSHI(mem,rc5))	"\tsarl\t%2,%1\n"	memop(a)
stmt: ASGNI(addr,RSHU(mem,rc5))	"\tshrl\t%2,%1\n"	memop(a)

reg: MULI(reg,mrc)	"?\tmovl\t%0,%c\n\timull\t%1,%c\n"  14
reg: MULI(con,mr)	"\timul\t%0,%1,%c\n"	13
reg: MULU(reg,mr)	"\tmull\t%1\n"		13
reg: DIVU(reg,reg)	"\txorl\t%%edx,%%edx\n\tdivl\t%1\n"
reg: MODU(reg,reg)	"\txorl\t%%edx,%%edx\n\tdivl\t%1\n"
reg: DIVI(reg,reg)	"\tcdq\n\tidivl\t%1\n"
reg: MODI(reg,reg)	"\tcdq\n\tidivl\t%1\n"
reg: CVIU(reg)		"\tmovl\t%0,%c\n"	move(a)
reg: CVPU(reg)		"\tmovl\t%0,%c\n"	move(a)
reg: CVUI(reg)		"\tmovl\t%0,%c\n"	move(a)
reg: CVUP(reg)		"\tmovl\t%0,%c\n"	move(a)
reg: CVCI(INDIRC(addr))	"\tmovsbl\t%0,%c\n"	3
reg: CVCU(INDIRC(addr))	"\tmovzbl\t%0,%c\n"	3
reg: CVSI(INDIRS(addr))	"\tmovswl\t%0,%c\n"	3
reg: CVSU(INDIRS(addr))	"\tmovzwl\t%0,%c\n"	3

reg: CVCI(reg)  "# extend\n"  3
reg: CVCU(reg)  "# extend\n"  3
reg: CVSI(reg)  "# extend\n"  3
reg: CVSU(reg)  "# extend\n"  3
reg: CVIC(reg)  "# truncate\n"  1
reg: CVIS(reg)  "# truncate\n"  1
reg: CVUC(reg)  "# truncate\n"  1
reg: CVUS(reg)  "# truncate\n"  1

mrca: mem  "%0"
mrca: rc   "%0"
mrca: ADDRGP "$%a"

stmt: ASGNC(addr,rc)	"\tmovb\t%1,%0\n"	1
stmt: ASGNI(addr,rc)	"\tmovl\t%1,%0\n"	1
stmt: ASGNP(addr,rc)	"\tmovl\t%1,%0\n"	1
stmt: ASGNS(addr,rc)	"\tmovw\t%1,%0\n"	1
stmt: ASGNB(reg,INDIRB(reg)) "\tmovl\t$%a,%%ecx\n\trep\n\tmovsb\n"
stmt: ARGI(mrca)	"\tpushl\t%0\n"  1
stmt: ARGP(mrca)	"\tpushl\t%0\n"  1
stmt: ARGB(INDIRB(reg)) "\tsubl\t$%a,%%esp\n\tmovl\t%%esp,%%edi\n\tmovl\t$%b,%%ecx\n\trep\n\tmovsb\n"

memf: INDIRD(addr)		"l\t%0"
memf: INDIRF(addr)		"s\t%0"
memf: CVFD(INDIRF(addr))	"s\t%0"
freg: memf			"\tfld%0\n"		3
stmt: ASGND(addr,freg)		"\tfstpl\t%0\n"  7
stmt: ASGNF(addr,freg)		"\tfstps\t%0\n"  7
stmt: ASGNF(addr,CVDF(freg))	"\tfstps\t%0\n"  7
stmt: ARGD(freg)		"\tsubl\t$8,%%esp\n\tfstpl\t(%%esp)\n"
stmt: ARGF(freg)		"\tsubl\t$4,%%esp\n\tfstps\t(%%esp)\n"
freg: NEGD(freg)		"\tfchs\n"
freg: NEGF(freg)		"\tfchs\n"

flt: memf	"%0"
flt: freg	"p\t%%st,%%st(1)"

freg: ADDD(freg,flt)	"\tfadd%1\n"
freg: ADDF(freg,flt)	"\tfadd%1\n"
freg: DIVD(freg,memf)	"\tfdiv%1\n"
freg: DIVD(freg,freg)	"\tfdivrp\t%%st,%%st(1)\n" 
freg: DIVF(freg,memf)	"\tfdiv%1\n"
freg: DIVF(freg,freg)	"\tfdivrp\t%%st,%%st(1)\n"
freg: MULD(freg,flt)	"\tfmul%1\n"
freg: MULF(freg,flt)	"\tfmul%1\n"
freg: SUBD(freg,memf)	"\tfsub%1\n"
freg: SUBD(freg,freg)	"\tfsubrp\t%%st,%%st(1)\n"
freg: SUBF(freg,memf)	"\tfsub%1\n"
freg: SUBF(freg,freg)	"\tfsubrp\t%%st,%%st(1)\n"
freg: CVFD(freg)  "# CVFD\n"
freg: CVDF(freg)  "\tsub\t$4,%%esp\n\tfstps (%%esp)\n\tflds (%%esp)\n\taddl $4,%%esp\n"  12

stmt: ASGNI(addr,CVDI(freg))  "\t.extern\t__ftol\n\tcall\t__ftol\n\tmovl\t%%eax,%0\n"  29
reg: CVDI(freg)  "\t.extern\t__ftol\n\tcall\t__ftol\n\tmovl\t%%eax,%c\n" 31

freg: CVID(INDIRI(addr))  "\tfildl\t%0\n"  10
freg: CVID(reg)  "\tpushl\t%0\n\tfildl\t(%%esp)\n\taddl\t$4,%%esp\n"  12

addrj: ADDRGP  "%a"
addrj: reg     "*%0"  2
addrj: mem     "*%0"  2

addrjmp: ADDRGP  "%a"
addrjmp: reg     "*%0"  2
addrjmp: mem     "*%0"  2

stmt: LABELV		"%a:\n"
stmt: JUMPV(addrjmp)	"\tjmp\t%0\n"  3
stmt: EQI(mem,rc)	"\tcmpl\t%1,%0\n\tje\t%a\n"   5
stmt: GEI(mem,rc)	"\tcmpl\t%1,%0\n\tjge\t%a\n"  5
stmt: GTI(mem,rc)	"\tcmpl\t%1,%0\n\tjg\t%a\n"   5
stmt: LEI(mem,rc)	"\tcmpl\t%1,%0\n\tjle\t%a\n"  5
stmt: LTI(mem,rc)	"\tcmpl\t%1,%0\n\tjl\t%a\n"   5
stmt: NEI(mem,rc)	"\tcmpl\t%1,%0\n\tjne\t%a\n"  5
stmt: GEU(mem,rc)	"\tcmpl\t%1,%0\n\tjae\t%a\n"  5
stmt: GTU(mem,rc)	"\tcmpl\t%1,%0\n\tja \t%a\n"  5
stmt: LEU(mem,rc)	"\tcmpl\t%1,%0\n\tjbe\t%a\n"  5
stmt: LTU(mem,rc)	"\tcmpl\t%1,%0\n\tjb \t%a\n"  5
stmt: EQI(reg,mrc)	"\tcmpl\t%1,%0\n\tje\t%a\n"   4
stmt: GEI(reg,mrc)	"\tcmpl\t%1,%0\n\tjge\t%a\n"  4
stmt: GTI(reg,mrc)	"\tcmpl\t%1,%0\n\tjg\t%a\n"   4
stmt: LEI(reg,mrc)	"\tcmpl\t%1,%0\n\tjle\t%a\n"  4
stmt: LTI(reg,mrc)	"\tcmpl\t%1,%0\n\tjl\t%a\n"   4
stmt: NEI(reg,mrc)	"\tcmpl\t%1,%0\n\tjne\t%a\n"  4

stmt: GEU(reg,mrc)	"\tcmpl\t%1,%0\n\tjae\t%a\n"  4
stmt: GTU(reg,mrc)	"\tcmpl\t%1,%0\n\tja \t%a\n"  4
stmt: LEU(reg,mrc)	"\tcmpl\t%1,%0\n\tjbe\t%a\n"  4
stmt: LTU(reg,mrc)	"\tcmpl\t%1,%0\n\tjb \t%a\n"  4

cmpf: INDIRD(addr)		"l\t%0"
cmpf: INDIRF(addr)		"s\t%0"
cmpf: CVFD(INDIRF(addr))	"s\t%0"
cmpf: freg	"p"

stmt: EQD(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tje\t%a\n"
;;stmt: EQD(cmpf,freg)  "\tfcomp%0\n\tfstsw %%ax\n\ttestb\t$40,%%ah\n\tjne\t%a\n"
;;stmt: NED(cmpf,freg)  "\tfcomp%0\n\tfstsw %%ax\n\ttestb\t$40,%%ah\n\tje\t%a\n" 1
stmt: GED(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjbe\t%a\n"
stmt: GTD(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjb\t%a\n"
;;stmt: GTD(cmpf,freg)  "\tfcomp%0\n\tfstsw %%ax\n\ttestb\t$45,%%ah\n\tjne\t%a\n"
stmt: LED(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjae\t%a\n"
;;stmt: LED(cmpf,freg)  "\tfcomp%0\n\tfstsw %%ax\n\ttestb\t$45,%%ah\n\tje\t%a\n"
stmt: LTD(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tja\t%a\n"
;;stmt: LTD(cmpf,freg)  "\tfcomp%0\n\tfstsw %%ax\n\ttestb\t$1,%%ah\n\tje\t%a\n"
;;stmt: GED(cmpf,freg)  "\tfcomp%0\n\tfstsw %%ax\n\ttestb\t$1,%%ah\n\tjne\t%a\n"
stmt: NED(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjne\t%a\n" 1

stmt: EQF(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tje\t%a\n"
stmt: GEF(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjbe\t%a\n"
stmt: GTF(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjb\t%a\n"
stmt: LEF(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjae\t%a\n"
stmt: LTF(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tja\t%a\n"
stmt: NEF(cmpf,freg)	"\tfcomp%0\n\tfstsw %%ax\n\tsahf\n\tjne\t%a\n"

reg:  CALLI(addrj)  "\tcall\t%0\n\taddl\t$%a,%%esp\n"	hasargs(a)
reg:  CALLI(addrj)  "\tcall\t%0\n"			1

stmt: CALLV(addrj)  "\tcall\t%0\n\taddl\t$%a,%%esp\n"	hasargs(a)
stmt: CALLV(addrj)  "\tcall\t%0\n"			1

freg: CALLF(addrj)  "\tcall\t%0\n\taddl\t$%a,%%esp\n"	hasargs(a)
freg: CALLF(addrj)  "\tcall\t%0\n"			1

stmt: CALLF(addrj)  "\tcall\t%0\n\taddl\t$%a,%%esp\n\tfstp\t%%st(0)\n"	hasargs(a)
stmt: CALLF(addrj)  "\tcall\t%0\n\tfstp\t%%st(0)\n"			1

freg: CALLD(addrj)  "\tcall\t%0\n\taddl\t$%a,%%esp\n"	hasargs(a)
freg: CALLD(addrj)  "\tcall\t%0\n"			1

stmt: CALLD(addrj)  "\tcall\t%0\n\taddl\t$%a,%%esp\n\tfstp\t%%st(0)\n"	hasargs(a)
stmt: CALLD(addrj)  "\tcall\t%0\n\tfstp\t%%st(0)\n"			1

stmt: RETI(reg)  "# ret\n" 1
stmt: RETF(freg)  "# retf\n"
stmt: RETD(freg)  "# retd\n"
;;
;; This part was added for the lcc-win32 x86 machine description.
;; In general this rules will NOT work with the standard front end because
;; they do not take into account the vacuous conversions: CVUP CVIU and all
;; others. I eliminated them in the front end since if we maintained them
;; this already long machine description would be completely unmanageable.
;; The number of rules increases exponentially when those conversions are
;; present. It is a simple modification of one line in dag.c
;;
;;
;; This rules have the general form:
;; ASGNX(addr,OPERATION(INDIRX(addr),constant))
;; Note that both addresses SHOULD BE THE SAME. This test is taken care
;; of by the function 'incrmem'.
;;
stmt: ASGNP(addr,ADDP(INDIRP(addr),acon)) "\taddl\t$%2,%0\n" incrmem(a)
stmt: ASGNP(addr,SUBP(INDIRP(addr),acon)) "\tsubl\t$%2,%0\n" incrmem(a)
stmt: ASGNI(addr,ADDI(INDIRI(addr),con))  "\taddl\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,ADDU(INDIRI(addr),con))  "\taddl\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,SUBI(INDIRI(addr),con))  "\tsubl\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,SUBU(INDIRI(addr),con))  "\tsubl\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,BANDU(INDIRI(addr),con)) "\tandl\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,BORU(INDIRI(addr),con))  "\torl\t%2,%0\n"  1+incrmem(a)
stmt: ASGNI(addr,BORU(INDIRI(addr),con16)) "\torw\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,LSHI(INDIRI(addr),con))  "\tsall\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,LSHU(INDIRI(addr),con))  "\tsall\t%2,%0\n" incrmem(a)
stmt: ASGNI(addr,RSHI(INDIRI(addr),con))  "\tsarl\t%2,%0\n" incrmem(a)

;;
;; This rules simplify unnecessary conversions from 1. Note that the
;; test for the tree shape is done by a different function since the
;; trees are different.
;;

stmt: ASGNS(addr,CVIS(ADDI(CVSI(INDIRS(addr)),con1))) "\tincw\t%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVIS(SUBI(CVSI(INDIRS(addr)),con1))) "\tdecw\t%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVIC(ADDI(CVCI(INDIRC(addr)),con1))) "\tincb\t%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVIC(SUBI(CVCI(INDIRC(addr)),con1))) "\tdecb\t%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(SUBI(CVCU(INDIRC(addr)),con1))) "\tdecb\t%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVUS(SUBI(CVSU(INDIRS(addr)),con1))) "\tdecw\t%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVUS(ADDI(CVSU(INDIRS(addr)),con1))) "\tincw\t%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(ADDI(CVCU(INDIRC(addr)),con1))) "\tincb\t%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(SUBI(CVCU(INDIRC(addr)),con1))) "\tdecb\t%0\n" immediateOpShort(a)

;;
;; This rules act directly between a constant and a memory location. Similar
;; to the rules above
;;

;;
;; First short convertions
;;
stmt: ASGNS(addr,CVIS(SUBI(CVSI(INDIRS(addr)),con)))  "\tsubw\t%2,%0\n" 1+immediateOpShort(a)
stmt: ASGNS(addr,CVIS(ADDI(CVSI(INDIRS(addr)),con)))  "\taddw\t%2,%0\n" 1+immediateOpShort(a)
stmt: ASGNS(addr,CVIS(BANDU(CVSI(INDIRS(addr)),con))) "\tandw\t%2,%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVIS(BORU(CVSI(INDIRS(addr)),con)))  "\torw\t%2,%0\n"  immediateOpShort(a)
stmt: ASGNS(addr,CVIS(LSHI(CVSI(INDIRS(addr)),con)))  "\tsalw\t%2,%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVIS(RSHI(CVSI(INDIRS(addr)),con)))  "\tsarw\t%2,%0\n" immediateOpShort(a)

stmt: ASGNS(addr,CVUS(SUBI(CVSU(INDIRS(addr)),con)))  "\tsubw\t%2,%0\n" 1+immediateOpShort(a)
stmt: ASGNS(addr,CVUS(ADDI(CVSU(INDIRS(addr)),con)))  "\taddw\t%2,%0\n" 1+immediateOpShort(a)
stmt: ASGNS(addr,CVUS(BANDU(CVSU(INDIRS(addr)),con))) "\tandw\t%2,%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVUS(BORU(CVSU(INDIRS(addr)),con)))  "\torw\t%2,%0\n"  immediateOpShort(a)
stmt: ASGNS(addr,CVUS(LSHI(CVSU(INDIRS(addr)),con)))  "\tsalw\t%2,%0\n" immediateOpShort(a)
stmt: ASGNS(addr,CVUS(RSHI(CVSU(INDIRS(addr)),con)))  "\tsarw\t%2,%0\n" immediateOpShort(a)

;; Then character conversions
;;
stmt: ASGNC(addr,CVUC(SUBI(CVCU(INDIRC(addr)),con)))  "\tsubb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(ADDI(CVCU(INDIRC(addr)),con)))  "\taddb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(BANDU(CVCU(INDIRC(addr)),con))) "\tandb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(BORU(CVCU(INDIRC(addr)),con)))  "\torb\t%2,%0\n"  immediateOpShort(a)
stmt: ASGNC(addr,CVUC(LSHI(CVCU(INDIRC(addr)),con)))  "\tsalb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVUC(RSHI(CVCU(INDIRC(addr)),con)))  "\tsarb\t%2,%0\n" immediateOpShort(a)

stmt: ASGNC(addr,CVIC(SUBI(CVCI(INDIRC(addr)),con)))  "\tsubb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVIC(ADDI(CVCI(INDIRC(addr)),con)))  "\taddb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVIC(BANDU(CVCI(INDIRC(addr)),con))) "\tandb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVIC(BORU(CVCI(INDIRC(addr)),con)))  "\torb\t%2,%0\n"  immediateOpShort(a)
stmt: ASGNC(addr,CVUC(BORU(CVCU(INDIRC(addr)),con)))  "\torl\t%2,%0\n"  1+immediateOpShort(a)
stmt: ASGNC(addr,CVUC(BORU(CVCU(INDIRC(addr)),con8))) "\torb\t%2,%0\n"  immediateOpShort(a)
stmt: ASGNC(addr,CVIC(LSHI(CVCI(INDIRC(addr)),con)))  "\tsalb\t%2,%0\n" immediateOpShort(a)
stmt: ASGNC(addr,CVIC(RSHI(CVCI(INDIRC(addr)),con)))  "\tsarb\t%2,%0\n" immediateOpShort(a)

;; This new terminals should be introduced at the beginning of the file.
;; Due to an internal 'hack' in 'emitasm', the integer that represents
;; a rule can't change, so I wrote all new rules later on. I will change that
;; when I have a little time...

zero: CNSTI     "0"     iszero(a)
zero: CNSTU     "0"     iszero(a)

con8: CNSTI     "%a"    iscon8(a)
con16: CNSTI    "%a"    iscon16(a)
;;mg: ADDRGP "%a"
;;reg: INDIRI(INDIRP(mg)) "\tmovl\t(%0),%c\n"

;; Comparisons with zero
;;
stmt: EQI(BANDU(mem,con8),zero) "\ttestb\t%1,%0\n\tje\t%a\n"
stmt: EQI(BANDU(mem,con16),zero) "\ttestw\t%1,%0\n\tje\t%a\n"
stmt: EQI(BANDU(mr,con),zero) "\ttestl\t%1,%0\n\tje\t%a\n" 3
stmt: NEI(BANDU(mr,con),zero) "\ttestl\t%1,%0\n\tjne\t%a\n"
stmt: EQI(BANDU(CVCU(mem8),con),zero) "\ttestb\t%1,%0\n\tje\t%a\n"
stmt: EQI(BANDU(CVCI(mem8),con),zero) "\ttestb\t%1,%0\n\tje\t%a\n"

stmt: EQI(BANDU(CVSI(INDIRS(addr)),con),zero) "\ttestw\t%1,%0\n\tje\t%a\n"
stmt: NEI(BANDU(CVSI(INDIRS(addr)),con),zero) "\ttestw\t%1,%0\n\tjne\t%a\n"
stmt: EQI(BANDU(CVSU(INDIRS(addr)),con),zero) "\ttestw\t%1,%0\n\tje\t%a\n"
stmt: NEI(BANDU(CVSU(INDIRS(addr)),con),zero) "\ttestw\t%1,%0\n\tjne\t%a\n"
stmt: EQI(BANDU(CVCI(INDIRC(addr)),con),zero) "\ttestb\t%1,%0\n\tje\t%a\n"
;;
;; this beauty results when you do the C statement:
;; if (isdigit(c))
;;
stmt: EQI(CVUI(BANDU(CVIU(CVUI(CVCU(INDIRC(mr)))),con)),zero) "\ttestb\t%1,%0\n\tje\t%a\n"
stmt: NEI(CVUI(BANDU(CVIU(CVUI(CVCU(INDIRC(mr)))),con)),zero) "\ttestb\t%1,%0\n\tje\t%a\n"
stmt: NEI(BANDU(INDIRI(addr),con8),zero) "\ttestb\t%1,%0\n\tjne\t%a\n"
stmt: NEI(BANDU(INDIRI(addr),con16),zero) "\ttestw\t%1,%0\n\tjne\t%a\n" 1
stmt: NEI(BANDU(INDIRI(addr),con),zero) "\ttestl\t%1,%0\n\tjne\t%a\n" 2
stmt: EQI(BANDU(INDIRI(addr),con),zero) "\ttestl\t%1,%0\n\tje\t%a\n"
stmt: EQI(BANDU(INDIRC(addr),con8),zero) "\ttestb\t%1,%0\n\tje\t%a\n"
stmt: NEI(BANDU(INDIRC(addr),con),zero) "\ttestb\t%1,%0\n\tjne\t%a\n"
stmt: EQI(BANDU(reg,con),zero) "\ttestl\t%1,%0\n\tje\t%a\n" 1
stmt: EQI(BANDU(reg,con16),zero) "\ttestw\t%1,%0\n\tje\t%a\n"
stmt: NEI(BANDU(reg,con),zero) "\ttestl\t%1,%0\n\tjne\t%a\n"
stmt: NEI(BANDU(INDIRI(addr),con16),zero) "\ttestw\t%1,%0\n\tjne\t%a\n"
;;stmt: EQI(reg,zero) "\torl\t%0,%0\n\tje\t%a\n"

;; Comparing directly a memory location to an immediate constant
;;
stmt: NEI(CVSI(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjne\t%a\n"
stmt: NEI(CVSU(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjne\t%a\n"
stmt: LEI(CVSI(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjle\t%a\n"
stmt: LEI(CVSU(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjbe\t%a\n"
stmt: LTI(CVSI(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjl\t%a\n"
stmt: LTI(CVSU(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjb\t%a\n"
stmt: GTI(CVSI(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjg\t%a\n"
stmt: GTU(CVSU(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tja\t%a\n"
stmt: GEI(CVSI(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjge\t%a\n"
stmt: GEI(CVSU(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tjae\t%a\n"
stmt: EQI(CVSI(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tje\t%a\n"
stmt: EQI(CVSU(INDIRS(addr)),rc) "\tcmpw\t%1,%0\n\tje\t%a\n"

stmt: NEI(CVCI(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjne\t%a\n"
stmt: NEI(CVCU(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjne\t%a\n"
stmt: EQI(CVCI(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tje\t%a\n"
stmt: EQI(CVCU(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tje\t%a\n"
stmt: LEI(CVCI(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjle\t%a\n"
stmt: LEU(CVCU(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjbe\t%a\n"
stmt: LTI(CVCI(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjl\t%a\n"
stmt: LTU(CVCU(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjb\t%a\n"
stmt: GTI(CVCI(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjg\t%a\n"
stmt: GTU(CVCU(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tja\t%a\n"
stmt: GEI(CVCI(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjge\t%a\n"
stmt: GEU(CVCU(INDIRC(addr)),con) "\tcmpb\t%1,%0\n\tjae\t%a\n"

base: ADDP(ADDRGP,acon) "%a+%1"
stmt: NEI(mem,con) "\tcmpl\t%1,%0\n\tjne\t%a\n"
stmt: EQI(mem,con) "\tcmpl\t%1,%0\n\tje\t%a\n"
stmt: LEI(mem,con) "\tcmpl\t%1,%0\n\tjle\t%a\n"
stmt: LEU(mem,con) "\tcmpl\t%1,%0\n\tjbe\t%a\n"
stmt: GEI(mem,con) "\tcmpl\t%1,%0\n\tjge\t%a\n"
stmt: GEU(mem,con) "\tcmpl\t%1,%0\n\tjae\t%a\n"
stmt: LTI(mem,con) "\tcmpl\t%1,%0\n\tjl\t%a\n"
stmt: LTU(mem,con) "\tcmpl\t%1,%0\n\tjb\t%a\n"

;; Comparing a word (16 bits) to a register. Note: the meaning
;; is preserved, but the jumps are in the *opposite direction*
;; because the register should be at the left side, if not my 
;; assembler will go nuts! Note that here we have:
;; %0,%1
;; instead of
;; %1,%0
;;

stmt: EQI(reg,CVSI(INDIRS(addr))) "\tcmpw\t%0,%1\n\tje\t%a\n"
stmt: NEI(reg,CVSI(INDIRS(addr))) "\tcmpw\t%0,%1\n\tjne\t%a\n"
stmt: LEI(reg,CVSI(INDIRS(addr))) "\tcmpw\t%0,%1\n\tjge\t%a\n"
stmt: LEU(reg,CVSU(INDIRS(addr))) "\tcmpw\t%0,%1\n\tjae\t%a\n"
stmt: GTI(reg,CVSI(INDIRS(addr))) "\tcmpw\t%0,%1\n\tjl\t%a\n"
stmt: GTU(reg,CVSU(INDIRS(addr))) "\tcmpw\t%0,%1\n\tjb\t%a\n"
stmt: LTI(reg,CVSI(INDIRS(addr))) "\tcmpw\t%0,%1\n\tjg\t%a\n"
stmt: LTU(reg,CVSU(INDIRS(addr))) "\tcmpw\t%0,%1\n\tja\t%a\n"
;;
;; This happens in the C idiom:
;; if (!somfn())
;; when somfn returns an unsigned short.
;;
stmt: NEI(CVSU(CVUS(reg)),zero)   "\torw\t%0,%0\n\tjne\t%a\n"
stmt: EQI(CVSU(CVUS(reg)),zero)   "\torw\t%0,%0\n\tje\t%a\n"
stmt: NEI(CVSI(CVIS(reg)),zero)   "\torw\t%0,%0\n\tjne\t%a\n"
stmt: EQI(CVSI(CVIS(reg)),zero)   "\torw\t%0,%0\n\tjne\t%a\n"

;; Some floating point constnts can be generated directly by the
;; machine. This is not faster but should save space in the data
;; segment once I convice the front end not to generate them.

dcon1: CNSTD "\tfld1\n" dequal(a,1)
dcon0: CNSTD "\tfldz\n" dequal(a,0)
dcon1: CNSTF "\tfld1\n" fequal(a,1)
dcon0: CNSTF "\tfldz\n" fequal(a,0)
freg: dcon1 "%0"
freg: dcon0 "%0"

;; This floating point operations were missing from the machine
;; description.

freg: DIVD(freg,CVID(INDIRI(addr))) "\tfidivl\t%1\n"
freg: DIVD(CVID(INDIRI(addr)),freg) "\tfidivrl\t%0\n"
freg: DIVD(freg,CVID(CVSI(INDIRS(addr)))) "\tfidivs\t%1\n"
freg: DIVD(CVID(CVSI(INDIRS(addr))),freg) "\tfidivrs\t%0\n"
freg: MULD(freg,CVID(INDIRI(addr))) "\tfimull\t%1\n"
freg: MULD(CVID(INDIRI(addr)),freg) "\tfimull\t%0\n"
freg: MULD(freg,CVID(CVSI(INDIRS(addr)))) "\tfimuls\t%1\n"
freg: SUBD(freg,CVID(INDIRI(addr))) "\tfisubl\t%1\n"
freg: SUBD(CVID(INDIRI(addr)),freg) "\tfisubrl\t%0\n"
freg: SUBD(freg,CVID(CVSI(INDIRS(addr)))) "\tfisubs\t%1\n"
freg: SUBD(CVID(CVSI(INDIRS(addr))),freg) "\tfisubrs\t%0\n"
freg: ADDD(freg,CVID(INDIRI(addr))) "\tfiaddl\t%1\n"
freg: ADDD(CVID(INDIRI(addr)),freg) "\tfiaddl\t%0\n"
freg: ADDD(freg,CVID(CVSI(INDIRS(addr)))) "\tfiadds\t%1\n"
freg: ADDD(freg,CVFD(INDIRF(addr))) "\tfdivs\t%1\n"
freg: SUBD(freg,CVFD(INDIRF(addr))) "\tfsubs\t%1\n"
freg: MULD(freg,CVFD(INDIRF(addr))) "\tfmuls\t%1\n"
freg: DIVD(freg,CVFD(INDIRF(addr))) "\tfdivs\t%1\n"
freg: LOADD(memf) "\tfld%0\n"

;;
;; Comparisons between byte/short reg with byte/short memory
;;
stmt: EQI(CVCU(reg),CVCU(INDIRC(addr))) "\tcmpb\t%1,%0\n\tje\t%a\n"
stmt: EQI(CVCI(reg),CVCI(INDIRC(addr))) "\tcmpb\t%1,%0\n\tje\t%a\n"
stmt: NEI(CVCU(reg),CVCU(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjne\t%a\n"
stmt: NEI(CVCI(reg),CVCI(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjne\t%a\n"
stmt: EQI(CVSI(reg),CVSI(INDIRS(addr))) "\tcmpw\t%1,%0\n\tje\t%a\n"
stmt: EQI(CVSU(reg),CVSU(INDIRS(addr))) "\tcmpw\t%1,%0\n\tje\t%a\n"
stmt: NEI(CVSU(reg),CVSU(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjne\t%a\n"
stmt: NEI(CVSI(reg),CVSI(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjne\t%a\n"
stmt: LEI(CVCU(reg),CVCU(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjbe\t%a\n"
stmt: LEI(CVCI(reg),CVCI(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjle\t%a\n"
stmt: LTU(CVCU(reg),CVCU(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjb\t%a\n"
stmt: LTI(CVCI(reg),CVCI(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjl\t%a\n"
stmt: GTI(CVCI(reg),CVCI(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjg\t%a\n"
stmt: GTU(CVCU(reg),CVCU(INDIRC(addr))) "\tcmpb\t%1,%0\n\tja\t%a\n"
stmt: GEI(CVCI(reg),CVCI(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjge\t%a\n"
stmt: GEI(CVCU(reg),CVCU(INDIRC(addr))) "\tcmpb\t%1,%0\n\tjae\t%a\n"
stmt: LEU(CVSU(reg),CVSU(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjbe\t%a\n"
stmt: LEI(CVSI(reg),CVSI(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjle\t%a\n"
stmt: LTI(CVSI(reg),CVSI(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjl\t%a\n"
stmt: LTU(CVSU(reg),CVSU(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjb\t%a\n"
stmt: GTI(CVSI(reg),CVSI(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjg\t%a\n"
stmt: GTU(CVSU(reg),CVSU(INDIRS(addr))) "\tcmpw\t%1,%0\n\tja\t%a\n"
stmt: GEI(CVSI(reg),CVSI(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjge\t%a\n"
stmt: GEU(CVSU(reg),CVSU(INDIRS(addr))) "\tcmpw\t%1,%0\n\tjae\t%a\n"

;;
;; This rule avoids a sequence of instructions like:
;; movsbl  (,%edi),%edx
;; movzbl  %dl,%edx
;; and replaces them for the shorter
;; movzbl  (,%edi),%edx
reg: CVCU(CVUC(CVCI(INDIRC(addr)))) "\tmovzbl\t%0,%c\n"
;;
;; This rule avoids a spurious register assignment when returning the
;; result of a function call.
stmt: RETI(LOADI(reg)) "?\tmovl\t%0,%%eax\n"
;; other RETI rules
stmt: RETI(ADDI(reg,acon)) "\tleal\t%1(%0),%%eax\n"
stmt: RETI(zero) "\txor\t%%eax,%%eax\n"
;;
;; 3 adds in one instruction
;;
reg: ADDP(reg,ADDP(reg,acon)) "\tleal\t%2(%0,%1),%c\n"
reg: ADDP(ADDP(reg,acon),reg) "\tleal\t%1(%0,%2),%c\n"
reg: ADDP(ADDP(reg,reg),acon) "\tleal\t%2(%0,%1),%c\n"
;;
;;stmt: ARGI(CVSI(CVIS(reg))) "\tpushl\t%0\n"
;;
;; I have separated the C files written by people from the C files
;; generated by lburg. I think this simplifies things a bit...
%%
#include "w32incl.c"
