/**********************************************************

  PROGRAM:  Jeu de Taquin

  PURPOSE:  The game of Jeu de Taquin for Microsoft Windows.

  AUTHOR:   Jere Kpyaho (jere@sci.fi)

  LAST MOD: 1997-04-30

***********************************************************/

#include <windows.h>            /* standard Windows includes */
#include <windowsx.h>
#include <stdlib.h>             /* for srand() */
#include <time.h>               /* for time() */
#include "taquin.h"             /* constants and public function prototypes */
#include "statbar.h"            /* our homegrown status bar */
#include "resource.h"           /* resource ID numbers */
#include "version.h"            /* version helper functions */

/****************************************************************

    F U N C T I O N    P R O T O T Y P E S

*****************************************************************/
BOOL InitApplication( HINSTANCE hInstance );
BOOL InitInstance( HINSTANCE hInstance, int nCmdShow );
void TermInstance( HINSTANCE hInstance );
int ShowMessage( HINSTANCE hInstance, HWND hwndParent, int iMessageID, int iTitleID, UINT fuStyle );

/****************************************************************

    G L O B A L   V A R I A B L E S

*****************************************************************/
HINSTANCE g_hInst = NULL;
HWND g_hwnd = NULL;
HWND g_hwndStatusBar = NULL;
HACCEL g_hAccel = NULL;
char g_szWindowClassName[32];

/**********************************************************/

int PASCAL WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                     LPSTR lpszCmdLine, int nCmdShow )
{
    HWND hwndFirst, hwndFirstChild;
    MSG msg;
    
    LoadString( hInstance, IDS_WINDOWCLASSNAME,
                g_szWindowClassName, sizeof(g_szWindowClassName) );
    hwndFirst = FindWindow( g_szWindowClassName, NULL );
    if ( hwndFirst != NULL )
    { 
        hwndFirstChild = GetLastActivePopup( hwndFirst );
        BringWindowToTop( hwndFirst );
        if ( hwndFirst != hwndFirstChild )
        {
            BringWindowToTop( hwndFirstChild );
        }
        return 0;
    }

    /* Initialize the random number generator. */
    srand( (unsigned) time( NULL ) );

    if ( !InitApplication( hInstance ) )
    {
        ShowMessage( hInstance, NULL, IDS_MSG_CLASSREGFAILED,
                     IDS_MSG_ERROR, MB_ICONSTOP | MB_OK );
        return 0;
    }

    if ( !InitInstance( hInstance, nCmdShow ) )
    {
        ShowMessage( hInstance, NULL, IDS_MSG_WINCREATEFAILED,
                     IDS_MSG_ERROR, MB_ICONSTOP | MB_OK );
        return 0;
    }

    while ( GetMessage( &msg, NULL, 0, 0 ) )
    {
        if ( !TranslateAccelerator( g_hwnd, g_hAccel, &msg ) )
        {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
    }

	TermInstance( hInstance );

    return (int)(msg.wParam);
}

BOOL InitApplication ( HINSTANCE hInstance )
{
    WNDCLASS wc;

    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = Taquin_WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon( hInstance, "AppIcon" );
    wc.hCursor       = LoadCursor( hInstance, "HandCursor" );
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
    wc.lpszMenuName  = "MainMenu";
    wc.lpszClassName = g_szWindowClassName;

    if ( !RegisterClass( &wc ) )
        return FALSE;

    if ( !StatusBar_Register( hInstance ) )
        return FALSE;

    return TRUE;
}

BOOL InitInstance ( HINSTANCE hInstance, int nCmdShow )
{
    char szWindowTitle[32];
    int cxWindow, cyWindow;
    DWORD dwStyle;
    HWND hwnd;
    RECT rectWindow, rectStatus;

    g_hInst = hInstance;

    g_hAccel = LoadAccelerators( g_hInst, "AccTable" );
    if ( g_hAccel == NULL )
    {
        return FALSE;
    }

    if ( !GetVersionInfo( hInstance, IDS_UNKNOWN ) )
    {
        ShowMessage( hInstance, NULL, IDS_MSG_NOVERSIONINFO,
                     IDS_MSG_ERROR, MB_ICONSTOP | MB_OK );
        return FALSE;
    }

    dwStyle = WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX;

    cxWindow = NUMCOLUMNS * TILEWIDTH + GetSystemMetrics( SM_CXBORDER );
    cyWindow = NUMROWS    * TILEHEIGHT + GetSystemMetrics( SM_CYBORDER ) +
                                       GetSystemMetrics( SM_CYCAPTION ) +
                                       GetSystemMetrics( SM_CYMENU );
    StatusBar_Initialize();
    cyWindow += StatusBar_GetHeight();

    LoadString( hInstance, IDS_WINDOWTITLE, szWindowTitle, sizeof(szWindowTitle) );

    hwnd = CreateWindow(
        g_szWindowClassName,          /* window class name */
        szWindowTitle,                /* window title */
        dwStyle,                      /* window style */
        CW_USEDEFAULT, CW_USEDEFAULT, /* use default location */
		cxWindow, cyWindow,           /* use precalculated size */
        NULL,                         /* has no parent window */
        NULL,                         /* use class menu */
        hInstance,                    /* handle of creating instance */
        NULL                          /* no creation parameters */
    );
    if ( hwnd == NULL )
    {
        return FALSE;
    }
    g_hwnd = hwnd;  /* save window handle */

    /* Center the window on the screen. */
    CenterWindow( hwnd, GetDesktopWindow() );

    ShowWindow( hwnd, nCmdShow );
    UpdateWindow( hwnd );

    return TRUE;
}

void TermInstance ( HINSTANCE hInstance )
{
    FreeVersionInfo();
}

