/********************************************************************

    VERSION.C -- helper functions for extracting version information.

*********************************************************************/

#include <windows.h>
#include <windowsx.h>
#include <ver.h>
#include <mem.h>     /* for _fmemcpy() (non-portable!) */
#include <stdlib.h>  /* for _MAX_PATH */
#include "version.h"

LPSTR GetVersionString( LPSTR lpszQuery );

VS_VARIABLEFILEINFO g_avsvfi[] = {
    { "Comments",        "" },
    { "CompanyName",     "" },
    { "FileDescription", "" },
    { "FileVersion",     "" },
    { "InternalName",    "" },
    { "LegalCopyright",  "" },
    { "LegalTrademarks", "" },
    { "OriginalFilename","" },
    { "PrivateBuild",    "" },
    { "ProductName",     "" },
    { "ProductVersion",  "" },
    { "SpecialBuild",    "" }
};
VS_FIXEDFILEINFO g_vsffi;
LPVOID g_lpvVersionInfo;
char g_szUnknown[32];     /* used if field value not found */

BOOL GetVersionInfo ( HINSTANCE hInstance, UINT uiUnknownStringID )
{
    char szFileName[_MAX_PATH];
    DWORD dwSize, dwHandle;
    VS_FIXEDFILEINFO FAR *lpvsffi;
    BOOL bResult;
    UINT cbInfo;
    LPDWORD lpdwTranslationInfo;
    UINT uiLangID, uiCharSetID;
    char szStringName[64];
    int iLength;
    int iField;

    LoadString( hInstance, uiUnknownStringID, g_szUnknown, sizeof(g_szUnknown) );

    dwSize = GetModuleFileName( hInstance, szFileName, sizeof(szFileName) );
    if ( 0 == dwSize )
        return FALSE;

    /*
     * Get version information size, allocate memory for it
     * and get the data. Return FALSE if any of these steps fail.
     */
    dwSize = GetFileVersionInfoSize( szFileName, &dwHandle );
    if ( 0 == dwSize )
        return FALSE;

    g_lpvVersionInfo = GlobalAllocPtr( GHND, dwSize );
    if ( NULL == g_lpvVersionInfo )
        return FALSE;

    bResult = GetFileVersionInfo( szFileName, dwHandle, dwSize, g_lpvVersionInfo );
    if ( !bResult )
        return FALSE;

    /*
     * Find the address of the VS_FIXEDFILEINFO structure.
     */
    if ( !VerQueryValue( g_lpvVersionInfo, "\\",
            (VOID FAR * FAR *) &lpvsffi, &cbInfo ) ||
         0 == cbInfo )
        return FALSE;

    _fmemcpy( &g_vsffi, lpvsffi, sizeof(VS_FIXEDFILEINFO) );

    /*
     * Get the variable-length version information.
     */
    VerQueryValue( g_lpvVersionInfo, "\\VarFileInfo\\Translation",
        (VOID FAR * FAR *) &lpdwTranslationInfo, &cbInfo );
    uiLangID = LOWORD(*lpdwTranslationInfo);
    uiCharSetID = HIWORD(*lpdwTranslationInfo);

    iLength = wsprintf( szStringName, "\\StringFileInfo\\%04x%04x\\", uiLangID, uiCharSetID );

    for ( iField = 0;  iField < NUMVARIABLEFIELDS;  iField++ )
    {
        lstrcat( szStringName, g_avsvfi[iField].szVerName );
        lstrcpy( g_avsvfi[iField].szVerValue, GetVersionString( szStringName ) );
        szStringName[iLength] = '\0';
    }

    /*
     * Return TRUE for success. The VerInfoVariable and
     * VerInfoFixed structures have been filled in.
     * The memory allocated will be freed when the application
     * terminates, using FreeVersionInfo().
     */
    return TRUE;
}

LPSTR GetVersionString ( LPSTR lpszQuery )
{
    UINT uiLength;
    LPVOID lpvData;

    if ( g_lpvVersionInfo == NULL )
        return g_szUnknown;

    if ( !VerQueryValue( g_lpvVersionInfo, lpszQuery, &lpvData, &uiLength ) )
        return g_szUnknown;

    if ( uiLength == 0 )
        return g_szUnknown;

    return lpvData;
}

void FreeVersionInfo ( void )
{
    if ( g_lpvVersionInfo != NULL )
    {
        GlobalFreePtr( g_lpvVersionInfo );
    }
}
