#ifndef TAQUIN_H
#define TAQUIN_H

#include <stdlib.h>  /* for _MAX_PATH */

#define NUMCOLUMNS 4
#define NUMROWS    4

#define TILEWIDTH  48
#define TILEHEIGHT 48

#define EMPTY       0           /* value in empty cell */

#define NUMSCRAMBLES 100        /* number of scrambling moves */

#define ID_STATUSBAR 1


/* Game data */
typedef enum tagGAMESTATE
{
	GS_IDLING, GS_SCRAMBLING, GS_PLAYING
}
GAMESTATE;

typedef struct tagGAMEDATA
{
	int iBlankRow;
	int iBlankColumn;
	int aiCells[NUMROWS][NUMCOLUMNS];
	GAMESTATE gsGameState;
}
GAMEDATA;

/* User interface settings: */
typedef struct tagSETTINGS
{
	BOOL bSound;
	char szFontName[LF_FACESIZE];  /* WINDOWS.H constant, matches LOGFONT.lfFaceName length */
	int iFontSize;
	BOOL bFontBold;
	BOOL bFontItalic;
	char szMoveSound[_MAX_PATH];
	char szBlockedSound[_MAX_PATH];
	char szSolvedSound[_MAX_PATH];
}
SETTINGS;

typedef enum tagGAMESOUND
{
	GSND_MOVE, GSND_BLOCKED, GSND_SOLVED
}
GAMESOUND;

/* GameData.c */
void GameData_Init( void );
BOOL GameData_IsSolved( void );
int  GameData_GetCell( int iRow, int iColumn );
void GameData_SetCell( int iRow, int iColumn, int iValue );
int  GameData_GetBlankColumn( void );
int  GameData_GetBlankRow   ( void );
void GameData_SetBlankCell( int iRow, int iColumn );
void GameData_SetGameState( GAMESTATE gsNewState );
GAMESTATE GameData_GetGameState( void );

/* MainWnd.c */
LRESULT CALLBACK _export Taquin_WndProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );

/* Paint.c */
void PaintTile( HDC hdc, int iRow, int iColumn, PLOGFONT plf );

/* Util.c */
int ShowMessage( HINSTANCE hInstance, HWND hwndParent, int iMessageID, int iTitleID, UINT fuStyle );
BOOL CenterWindow( HWND hwndChild, HWND hwndParent );
void Scramble( HWND hwnd );
BOOL SelectTileFont( HWND hwnd, PLOGFONT plf );
void PlayGameSound( UINT uiSound, UINT uiFlags );
char *GetString( HINSTANCE hInstance, WORD wID );

/* Settings.c */
void Settings_EnableSound( void );
void Settings_DisableSound( void );
BOOL Settings_IsSoundEnabled( void );
void Settings_SetFont( char *szNewFontName, int iNewFontSize, BOOL bIsFontBold, BOOL bIsFontItalic );
int Settings_GetFontSize( void );
BOOL Settings_IsFontBold( void );
BOOL Settings_IsFontItalic( void );
void Settings_GetFontName( char *szFontNameBuffer );
void Settings_SetSoundName( GAMESOUND gsnd, char *szNewSoundName );
void Settings_GetSoundName( GAMESOUND gsnd, char *szSoundNameBuffer );
BOOL Settings_Read( void );
BOOL Settings_Write( void );

/* About.c */
BOOL CALLBACK _export About_DlgProc( HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam );

/* Global variable access: */
extern HINSTANCE g_hInst;       /* Taquin.c  */
extern HWND g_hwndStatusBar;    /* Taquin.c  */
extern BOOL g_bSettingsChanged; /* MainWnd.c */
extern int g_iLastStatusMessage;/* MainWnd.c */
extern LOGFONT g_lfTileFont;    /* MainWnd.c */
extern char g_szHelpFileName[_MAX_PATH]; /* MainWnd.c */
extern LPVOID g_lpvVersionInfo; /* Version.c */

#endif

