#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>     /* for rand() */
#include <string.h>     /* for memset() */
#include "taquin.h"

int ShowMessage ( HINSTANCE hInstance, HWND hwndParent, 
				  int iMessageID, int iTitleID, UINT fuStyle )
{
    static char szMessage[256];
    static char szTitle[32];
    int rc = 0;
    
    /* If both string loads are successful, display the message box. */
    if ( LoadString( hInstance, iMessageID,
		             szMessage, sizeof(szMessage) ) != 0 &&
         LoadString( hInstance, iTitleID,
		             szTitle, sizeof(szTitle) ) != 0 )
    {
        rc = MessageBox( hwndParent, szMessage, szTitle, fuStyle );
    }
    return rc;
}

BOOL CenterWindow ( HWND hwndChild, HWND hwndParent )
{
    RECT    rectChild, rectParent, rectWorkArea;
    int     cxChild, cyChild, cxParent, cyParent;
    int     xNew, yNew;
    BOOL    bResult;

    /* Get the height and width of the child window: */
    GetWindowRect( hwndChild, &rectChild );
    cxChild = rectChild.right - rectChild.left;
    cyChild = rectChild.bottom - rectChild.top;

    /* Get the height and width of the parent window: */
    GetWindowRect( hwndParent, &rectParent );
    cxParent = rectParent.right - rectParent.left;
    cyParent = rectParent.bottom - rectParent.top;

    bResult = SystemParametersInfo( SPI_GETWORKAREA,
        sizeof(RECT), &rectWorkArea, 0 );
    if ( !bResult )
    {
        rectWorkArea.left = rectWorkArea.top = 0;
        rectWorkArea.right = GetSystemMetrics(SM_CXSCREEN);
        rectWorkArea.bottom = GetSystemMetrics(SM_CYSCREEN);
    }

    xNew = rectParent.left + ( (cxParent - cxChild) / 2 );
    yNew = rectParent.top  + ( (cyParent - cyChild) / 2 );

    if ( xNew < rectWorkArea.left )
    {
        xNew = rectWorkArea.left;
    }
    else if ( (xNew + cxChild) > rectWorkArea.right)
    {
        xNew = rectWorkArea.right - cxChild;
    }

    if ( yNew < rectWorkArea.top )
    {
        yNew = rectWorkArea.top;
    }
    else if ( (yNew + cyChild) > rectWorkArea.bottom )
    {
        yNew = rectWorkArea.bottom - cyChild;
    }

    return SetWindowPos( hwndChild, NULL,
                         xNew, yNew, 0, 0,
                         SWP_NOSIZE | SWP_NOZORDER );
}

void Scramble ( HWND hwnd )
{
    int cRepeats;

    for ( cRepeats = 0;  cRepeats < NUMSCRAMBLES;  cRepeats++ )
    {
        MSG msg;

        /* let other applications execute */
        while ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
        {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }

        SendMessage( hwnd, WM_LBUTTONDOWN, 0,
		    MAKELPARAM( rand() % NUMCOLUMNS * g_cxTile, GameData_GetBlankRow() * g_cyTile ) );
        UpdateWindow( hwnd );

        SendMessage( hwnd, WM_LBUTTONDOWN, 0,
			MAKELPARAM( GameData_GetBlankColumn() * g_cxTile, rand() % NUMROWS * g_cyTile ) );
        UpdateWindow( hwnd );
    }
}

BOOL SelectTileFont ( HWND hwnd, PLOGFONT plf )
{
    static CHOOSEFONT cf;
    
    memset( &cf, 0, sizeof(CHOOSEFONT) );
    cf.lStructSize = sizeof(CHOOSEFONT);
    cf.hwndOwner = hwnd;
    cf.lpLogFont = plf;
    cf.Flags = CF_SCREENFONTS          |  /* screen fonts */
               CF_ANSIONLY             |  /* ANSI characters only (no symbols) */
               CF_TTONLY               |  /* TrueType fonts only */
               CF_FORCEFONTEXIST       |  /* only allow selection of existing fonts */
               CF_NOVECTORFONTS        |  /* no vector fonts allowed */
               CF_INITTOLOGFONTSTRUCT;    /* initialize the LOGFONT structure */
    ChooseFont( &cf );

    Settings_SetFont(
        plf->lfFaceName,
        cf.iPointSize / 10,  /* tenths of a point */
        (plf->lfWeight == FW_BOLD) ? TRUE : FALSE,
        (plf->lfItalic != 0) ? TRUE : FALSE );

    return TRUE;
}

void PlayGameSound ( UINT uiSound, UINT uiFlags )
{
    char szSoundName[_MAX_PATH];
    DWORD dwFlags;

    if ( !Settings_IsSoundEnabled() )
    {
        return;
    }

    Settings_GetSoundName( uiSound, szSoundName );

    dwFlags = (DWORD)uiFlags;
    dwFlags = dwFlags | SND_FILENAME;
    PlaySound( szSoundName, NULL, dwFlags );
}

char *GetString ( HINSTANCE hInstance, WORD wID )
{
    static char szBuffer[128];

    LoadString( hInstance, wID, szBuffer, sizeof(szBuffer) );
    return szBuffer;
}

void MenuCheckMark (HMENU hmenu, int id, BOOL bCheck)
{
    int iState = (bCheck) ? MF_CHECKED : MF_UNCHECKED;
    CheckMenuItem (hmenu, id, iState);
}

