#include <windows.h>
#include <windowsx.h>
#include "taquin.h"

#define MoveTo( hdc, x, y )  MoveToEx( hdc, x, y, NULL )

void DrawValue( HDC hdc, LPRECT lprc, int iValue, PLOGFONT plf );
void Draw3DBorder( HDC hdc, LPRECT lprc );

void PaintTile ( HDC hdc, int iRow, int iColumn, PLOGFONT plf )
{
    RECT rc;
    int iValue;
    HBRUSH hbrBack, hbrOld;
    HPEN hpenFrame, hpenOld;
    
    /* Calculate the rectangle for the tile at (iColumn, iRow). */
    /* Can't use SetRect because right and bottom depend on left and top. */
	rc.left   = iColumn * g_cxTile;
	rc.top    = iRow * g_cyTile;
	rc.right  = rc.left + g_cxTile;
	rc.bottom = rc.top + g_cyTile;

    iValue = GameData_GetCell( iRow, iColumn );
    if ( iValue == EMPTY ) /* it is the blank cell */
    {
        /* Create the background brush and select it. */
        hbrBack = CreateSolidBrush( GetSysColor( COLOR_WINDOW ) );
        hbrOld = SelectBrush( hdc, hbrBack );
        
        /* Create the frame pen and select it. */
        hpenFrame = CreatePen( PS_SOLID, 1, GetSysColor( COLOR_WINDOWFRAME ) );
        hpenOld = SelectPen( hdc, hpenFrame );
        
        /* Draw tile rectangle using frame pen and fill it using background brush. */
        Rectangle( hdc, rc.left, rc.top, rc.right, rc.bottom );
        
        SelectPen( hdc, hpenOld );
        DeletePen( hpenFrame );
        
        SelectBrush( hdc, hbrOld );
        DeleteBrush( hbrBack );
    }
    else
    {
        hbrBack = CreateSolidBrush( GetSysColor( COLOR_BTNFACE ) );
        hbrOld = SelectBrush( hdc, hbrBack ); 
    
        hpenFrame = CreatePen( PS_SOLID, 1, GetSysColor( COLOR_WINDOWFRAME ) );
        hpenOld = SelectPen( hdc, hpenFrame );

        /* Draw frame around the tile, and paint the tile. */
        Rectangle( hdc, rc.left, rc.top, rc.right, rc.bottom ); 
    
        /* Draw highlight and shadow for tile. */
        Draw3DBorder( hdc, &rc );

        /* Draw the value inside the tile. */    
        DrawValue( hdc, &rc, iValue, plf );

        SelectPen( hdc, hpenOld );
        DeletePen( hpenFrame );
    
        SelectBrush( hdc, hbrOld );
        DeleteBrush( hbrBack );    
    }
}

void DrawValue ( HDC hdc, LPRECT lprc, int iValue, PLOGFONT plf )
{
    char szValue[3];
    HFONT hfontNew, hfontOld;
    
    wsprintf( szValue, "%d", iValue );
    
    hfontNew = CreateFontIndirect( plf );
    hfontOld = SelectFont( hdc, hfontNew );

    SetTextColor( hdc, GetSysColor( COLOR_BTNTEXT ) );
    SetBkMode( hdc, TRANSPARENT );
    DrawText( hdc, szValue, lstrlen(szValue), lprc,
        DT_SINGLELINE | DT_CENTER | DT_VCENTER );
    SetBkMode( hdc, OPAQUE );        

    SelectFont( hdc, hfontOld );
    DeleteFont( hfontNew );
}

void Draw3DBorder ( HDC hdc, LPRECT lprc )
{
    RECT rc;
    HPEN hpenHighlight, hpenShadow, hpenOld;
    
    CopyRect( &rc, lprc );
    
    hpenHighlight = CreatePen( PS_SOLID, 1, GetSysColor( COLOR_BTNHIGHLIGHT ) );
    hpenShadow = CreatePen( PS_SOLID, 1, GetSysColor( COLOR_BTNSHADOW ) );
    
    hpenOld = SelectPen( hdc, hpenHighlight );
    MoveTo( hdc, rc.left + 1, rc.top + 1 );
    LineTo( hdc, rc.right - 1, rc.top + 1 );
    MoveTo( hdc, rc.left + 1, rc.top + 1 );
    LineTo( hdc, rc.left + 1, rc.bottom - 1 );    
    
    MoveTo( hdc, rc.left + 2, rc.top + 2 );
    LineTo( hdc, rc.right - 2, rc.top + 2 );
    MoveTo( hdc, rc.left + 2, rc.top + 2 );
    LineTo( hdc, rc.left + 2, rc.bottom - 2 );

    SelectPen( hdc, hpenShadow );

    MoveTo( hdc, rc.right - 2, rc.bottom - 2 );
    LineTo( hdc, rc.right - 2, rc.top + 1 );
    MoveTo( hdc, rc.right - 2, rc.bottom - 2 );
    LineTo( hdc, rc.left + 1, rc.bottom - 2 );
    
    MoveTo( hdc, rc.right - 3, rc.bottom - 3 );
    LineTo( hdc, rc.left + 2, rc.bottom - 3 );
    MoveTo( hdc, rc.right - 3, rc.bottom - 3 );
    LineTo( hdc, rc.right - 3, rc.top + 2 );
    
    SelectPen( hdc, hpenOld );
    DeletePen( hpenShadow );
    DeletePen( hpenHighlight );
}

