#include <windows.h>    /* just for BOOL, TRUE, and FALSE */
#include "taquin.h"

static GAMEDATA GameData;

void GameData_Init ( void )
{
    int iRow, iColumn;

    for ( iRow = 0;  iRow < NUMROWS;  iRow++ )
        for ( iColumn = 0;  iColumn < NUMCOLUMNS;  iColumn++ )
            GameData_SetCell( iRow, iColumn, iRow * NUMROWS + iColumn + 1 );

    GameData_SetBlankCell( NUMROWS - 1, NUMCOLUMNS - 1 );
    
    GameData_SetCell( GameData_GetBlankRow(), GameData_GetBlankColumn(), EMPTY );
    
    GameData.gsGameState = GS_IDLING;
}

/*
 * Check for a solution. Make sure that the puzzle position is the same
 * as the initial position. Special checking on the blank position.
 */
BOOL GameData_IsSolved ( void )
{
    int iRow, iColumn;

    GameData_SetCell( GameData_GetBlankRow(), GameData_GetBlankColumn(), 16 );

    for ( iRow = 0;  iRow < NUMROWS;  iRow++ )
        for ( iColumn = 0;  iColumn < NUMCOLUMNS;  iColumn++ )
        {
            if ( GameData_GetCell( iRow, iColumn ) != iRow * NUMROWS + iColumn + 1 )
            {
                GameData_SetCell( GameData_GetBlankRow(), GameData_GetBlankColumn(), EMPTY );
                return FALSE;
            }
        }

    return TRUE;
}

/* Return the value of the cell at (iRow, iColumn). */
int GameData_GetCell ( int iRow, int iColumn )
{
    return GameData.aiCells[iRow][iColumn];
}

/* Set the cell at (iRow, iColumn) to iValue. */
void GameData_SetCell ( int iRow, int iColumn, int iValue )
{
    GameData.aiCells[iRow][iColumn] = iValue;
}

int GameData_GetBlankColumn ( void ) { return GameData.iBlankColumn; }
int GameData_GetBlankRow    ( void ) { return GameData.iBlankRow; }

void GameData_SetBlankCell ( int iRow, int iColumn )
{
    GameData.iBlankRow = iRow;
    GameData.iBlankColumn = iColumn;
    GameData.aiCells[iRow][iColumn] = EMPTY;
}

void GameData_SetGameState ( GAMESTATE gsNewState ) { GameData.gsGameState = gsNewState; }
GAMESTATE GameData_GetGameState ( void ) { return GameData.gsGameState; }

