#include <windows.h>
#include <commctrl.h>   /* Win32 common control library */
#include "taquin.h"
#include "resource.h"
#include "commands.h"

void Taquin_OnCmd_GameNew( HWND hwnd, HWND hwndCtl, UINT codeNotify )
{
    char szMessage[256];
    HCURSOR hcurOld;

	if ( GameData_GetGameState() == GS_PLAYING )
    {
	    int rc = ShowMessage( g_hInst, hwnd, IDS_MSG_RESTARTGAME,
            IDS_WINDOWTITLE, MB_ICONQUESTION | MB_YESNO );
        if ( rc == IDNO )
            return;
    }

    GameData_Init();
    GameData_SetGameState( GS_SCRAMBLING );

    lstrcpy( szMessage, GetString( g_hInst, IDS_STAT_SCRAMBLING ) );    
    SendMessage( g_hwndStatusBar, SB_SETTEXT, 0, (LPARAM)szMessage );
    g_iLastStatusMessage = IDS_STAT_SCRAMBLING;

    hcurOld = SetCursor( LoadCursor( NULL, IDC_WAIT ) );
    ShowCursor( TRUE );
    Scramble( hwnd );
    ShowCursor( FALSE );
    SetCursor( hcurOld );

    lstrcpy( szMessage, GetString( g_hInst, IDS_STAT_READY ) );
    SendMessage( g_hwndStatusBar, SB_SETTEXT, 0, (LPARAM)szMessage );
    g_iLastStatusMessage = IDS_STAT_READY;

    GameData_SetGameState( GS_PLAYING );
}

void Taquin_OnCmd_GameExit( HWND hwnd, HWND hwndCtl, UINT codeNotify )
{
    SendMessage( hwnd, WM_CLOSE, 0, 0L );
}

void Taquin_OnCmd_OptionsSound( HWND hwnd, HWND hwndCtl, UINT codeNotify )
{
	if ( Settings_IsSoundEnabled() )
    {
        Settings_DisableSound();
    }
    else
    {
        Settings_EnableSound();
    }
    
    CheckMenuItem( GetMenu( hwnd ), IDM_OPTIONS_SOUND,
        Settings_IsSoundEnabled() ? MF_CHECKED : MF_UNCHECKED );
    g_bSettingsChanged = TRUE;
}

void Taquin_OnCmd_OptionsFont( HWND hwnd, HWND hwndCtl, UINT codeNotify )
{
    if ( SelectTileFont( hwnd, &g_lfTileFont ) )
    {
        InvalidateRect( hwnd, NULL, TRUE );
        g_bSettingsChanged = TRUE;
    }
}

void Taquin_OnCmd_HelpContents( HWND hwnd, HWND hwndCtl, UINT codeNotify )
{
	WinHelp( hwnd, g_szHelpFileName, HELP_FINDER, 0 );
}

void Taquin_OnCmd_HelpAbout( HWND hwnd, HWND hwndCtl, UINT codeNotify )
{
	DialogBox( g_hInst, "AboutDlg", hwnd, About_DlgProc );
}
