#include <windows.h>           /* standard Windows includes */
#include <windowsx.h>          /* helper macros */
#include <winver.h>            /* version information stuff */
#include "taquin.h"            /* constants */
#include "resource.h"          /* resource identifiers */
#include "version.h"           /* version helpers */

/* Local function prototypes for message handlers */
BOOL About_OnInitDialog( HWND hwnd, HWND hwndFocus, LPARAM lParam );
void About_OnCommand( HWND hwnd, int id, HWND hwndCtl, UINT codeNotify );


/********************************************************************

	FUNCTION:   About_DlgProc

	PURPOSE:    Dialog box procedure for the "About" dialog box.

	ARGUMENTS:  hdlg            handle of dialog box window
                message         message identifier
                wParam          short parameter of message
                lParam          long parameter of message

	RETURNS:    If the message was processed, returns TRUE.
                If the message was not processed, returns FALSE.

	MESSAGES:   WM_INITDIALOG
				WM_COMMAND

*********************************************************************/
BOOL CALLBACK About_DlgProc ( HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	BOOL fResult = FALSE;

	switch ( message )
	{
		case WM_INITDIALOG:
			fResult = (BOOL) HANDLE_WM_INITDIALOG( hdlg, wParam, lParam, About_OnInitDialog );
			break;

		case WM_COMMAND:
			HANDLE_WM_COMMAND( hdlg, wParam, lParam, About_OnCommand );
			fResult = TRUE;
			break;

		default:
			break;
	}

	return fResult;
}


/********************************************************************

	FUNCTION:   About_OnInitDialog

	PURPOSE:    Handles the WM_ONINITDIALOG message for the About box.
				Reads the version information resource and shows it
				in the dialog fields (FileDescription, FileVersion,
				and LegalCopyright).

	ARGUMENTS:  hwnd        handle of dialog window
				hwndFocus   handle of control to set focus to
				lParam

	RETURNS:    TRUE to set the focus to hwndFocus, FALSE otherwise.

*********************************************************************/
BOOL About_OnInitDialog ( HWND hwnd, HWND hwndFocus, LPARAM lParam )
{
	char szAbout[32];
	char szTitle[32];
	char szCaption[64];
	char szVersion[32];

	/* Load "About" and application name strings and make a caption. */
	LoadString( g_hInst, IDS_ABOUT, szAbout, sizeof(szAbout) );
	LoadString( g_hInst, IDS_WINDOWTITLE, szTitle, sizeof(szTitle) );
	wsprintf( szCaption, "%s %s", szAbout, szTitle );
	SetWindowText( hwnd, szCaption );

    /* Load "Version" and make a version string. */
	LoadString( g_hInst, IDS_VERSION, szVersion, sizeof(szVersion) );
    lstrcat( szVersion, " " );
    lstrcat( szVersion, g_avsvfi[VF_VF_PRODUCTVERSION].szVerValue );

	SetDlgItemText( hwnd, IDD_PRODUCTNAME, g_avsvfi[VF_VF_PRODUCTNAME].szVerValue );
	SetDlgItemText( hwnd, IDD_PRODUCTVERSION, szVersion );
	SetDlgItemText( hwnd, IDD_LEGALCOPYRIGHT, g_avsvfi[VF_VF_LEGALCOPYRIGHT].szVerValue );

	return TRUE;
}


void About_OnCommand ( HWND hwnd, int id, HWND hwndCtl, UINT codeNotify )
{
	EndDialog( hwnd, 0 );
}
