'******************************************************************************
' File:      playstk.c
' Version:   1.00
' Tab stops: every 2 columns
' Project:   DiamondWare's Sound ToolKit for Windows
' Copyright: 1996 DiamondWare, Ltd.  All rights reserved.*
' Written:   95/12/11 by David Alen
' Purpose:   Contains sample application using the WIN-STK
' History:   96/03/28 KW & JCL finalized for 1.0
'            96/04/14 JCL finalized for 1.01
'            96/05/13 JCL finalized for 1.1 (no changes)
'
'*Permission is expressely granted to use this program or any derivitive made
' from it to registered users of the WIN-STK.
'******************************************************************************



Option Explicit

Type OFSTRUCT
    cBytes As String * 1
    fFixedDisk As String * 1
    nErrCode As Integer
    reserved As String * 4
    szPathName As String * 128
End Type

Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer

Declare Function OpenFile Lib "Kernel" (ByVal lpFileName As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Integer) As Integer
Declare Function llseek Lib "Kernel" Alias "_llseek" (ByVal hfile As Integer, ByVal lOffset As Long, ByVal iOrigin As Integer) As Long
Declare Function hRead Lib "Kernel" Alias "_hread" (ByVal hfile As Integer, ByVal lOffset As Long, ByVal iSize As Long) As Long
Declare Function lclose Lib "Kernel" Alias "_lclose" (ByVal hfile As Integer) As Integer

Global Const OF_READ = &H0

Global Const GENERIC_READ = &H80000000
Global Const FILE_SHARE_READ = &H1
Global Const OPEN_EXISTING = 3
Global Const FILE_ATTRIBUTE_NORMAL = &H80
Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_SHARE = &H2000

Global Const CD_ACTION_OPEN = 1

Global Const dws_NOSUCCESS = 0

Type SoundInfo
    FileName As String
    Handle As Long
    UnlockHandle As Integer
    soundnum As Integer
    Rate As Integer
End Type

Global t_dws_DR As type_dws_DETECTRESULTS
Global t_dws_ID As type_dws_IDEAL
Global t_dws_DP As type_dws_DPlay
Global t_dws_MP As type_dws_MPlay

Global giNumSounds As Integer
Global gtSI() As SoundInfo
Global gPlay As type_dws_DPlay

Function dwsLoadWave (psFileName As String) As Integer
    ' This procedure loads the passed WAVE file and
    ' prepares it for use with the WinSTK.  It returns the INDEX of gtSI()
    ' that the wave was loaded into.

    On Error GoTo LWE

    Dim WaveDwd As Long
    Dim hWaveDwd As Long
    Dim WaveTmp As Long
    Dim hWaveTmp As Long
    Dim iStatus As Integer
    Dim lLen As Long
    Dim lTemp As Long
    Dim hfile As Long
    Dim iLoop As Integer
    Dim iIndex As Integer
    
    Dim iResult As Integer
    
    Dim openbuff As OFSTRUCT
    
    hfile = OpenFile(psFileName, openbuff, OF_READ)
    
    If hfile > 0 Then
	lLen = llseek(hfile, 0&, 2)

	hWaveTmp = GlobalAlloc(GMEM_MOVEABLE Or GMEM_SHARE, lLen)
	WaveTmp = GlobalLock(hWaveTmp)

	iResult = llseek(hfile, 0&, 0)
	iResult = hRead(hfile, WaveTmp, lLen)
	iResult = lclose(hfile)
    Else
	Exit Function
    End If
    
    If InStr(UCase(psFileName), ".WAV") Then
	'  convert WAV to DWD
	lTemp = lLen
	iStatus = dws_WAV2DWD(ByVal WaveTmp, lTemp, ByVal 0&)
	If iStatus = False Then
	    dwsShowError
	    Exit Function
	End If
    
	hWaveDwd = GlobalAlloc(GMEM_MOVEABLE, lTemp)
	WaveDwd = GlobalLock(hWaveDwd)
    
	iStatus = dws_WAV2DWD(ByVal WaveTmp, lLen, ByVal WaveDwd)
    
	iResult = GlobalUnlock(hWaveTmp)
	iResult = GlobalFree(hWaveTmp)
    
	If iStatus = False Then
	    iResult = GlobalUnlock(hWaveDwd)
	    iResult = GlobalFree(hWaveDwd)
	    dwsShowError
	    Exit Function
	End If
    Else
	hWaveDwd = hWaveTmp
	WaveDwd = WaveTmp
    End If
    
    iIndex = -1
    
    giNumSounds = giNumSounds + 1
    
    ' Find an empty index if exists
    For iLoop = 0 To UBound(gtSI)
	If gtSI(iLoop).Handle = 0 Then
	    ' Use this one!
	    iIndex = iLoop
	    Exit For
	End If
    Next iLoop
    
    If iIndex = -1 Then
	ReDim Preserve gtSI(UBound(gtSI) + 1) As SoundInfo
	iIndex = UBound(gtSI)
    End If
    
    gtSI(iIndex).FileName = psFileName
    gtSI(iIndex).Handle = WaveDwd
    gtSI(iIndex).UnlockHandle = hWaveDwd

    iResult = dws_DGetRateFromDWD(ByVal gtSI(iIndex).Handle, gtSI(iIndex).Rate)
    
    dwsLoadWave = iIndex
    
LWER:
    Exit Function
    
LWE:
    dwsLoadWave = -1
    MsgBox "Error '" + Error + "' occurred in DWSTEST:dwsLoadWave!"
    Resume LWER
End Function

Function dwsPlayWave (piIndex As Integer) As Integer
    ' This procedure plays a loaded wave by using the passed
    ' memory handle.

    Dim tPlay As type_dws_DPlay
    Dim iStatus As Integer

    LSet tPlay = gPlay
    
    tPlay.snd = gtSI(piIndex).Handle
    tPlay.Count = 1
    
    tPlay.flags = dws_dplay_SND Or dws_dplay_COUNT Or dws_dplay_LVOL Or dws_dplay_RVOL Or dws_dplay_PITCH
    
    iStatus = dws_DPlay(tPlay)
	
    gtSI(piIndex).soundnum = tPlay.soundnum
    
    If iStatus = 0 Then
	dwsShowError
	Exit Function
    End If
    
    dwsPlayWave = True
End Function

Sub dwsShowError ()
    ' An error has occurred!  Show it!
    Dim iError As Integer
    Dim sError As String
    
    iError = dws_ErrNo()
    
    Select Case iError
	Case dws_NOTINITTED
	    sError = "Not Initialized"
	Case dws_ALREADYINITTED
	    sError = "Already Initialized"
	Case dws_NOTSUPPORTED
	    sError = "Not Supported"
	Case dws_INTERNALERROR
	    sError = "Internal Error"
	Case dws_INVALIDPOINTER
	    sError = "Invalid Pointer"
	Case dws_RESOURCEINUSE
	    sError = "Resource In Use"
	Case dws_MEMORYALLOCFAILED
	    sError = "Memory Alloc Failed"
	Case dws_SETEVENTFAILED
	    sError = "Set Event Failed"
	Case dws_BUSY
	    sError = "Busy"
	Case dws_Init_BUFTOOSMALL
	    sError = "Buffer Too Small"
	Case dws_D_NOTADWD
	    sError = "Not a DWD"
	Case dws_D_NOTSUPPORTEDVER
	    sError = "Not Supported Version"
	Case dws_D_BADDPLAY
	    sError = "Bad (D) Play"
	Case dws_DPlay_NOSPACEFORSOUND
	    sError = "No Space For Sound"
	Case dws_WAV2DWD_NOTAWAVE
	    sError = "Not A Wave"
	Case dws_WAV2DWD_UNSUPPORTEDFORMAT
	    sError = "Unsupport Format"
	Case dws_M_BADMPLAY
	    sError = "Bad (M) Play"
	Case Else
	    sError = "<unknown #" + CStr(iError) + ">"
    End Select
    
    MsgBox "Error '" + sError + "' occurred!"
End Sub

Function dwsUnloadWave (piIndex As Integer) As Integer
    ' This procedure removes a loaded WAVE file via
    ' the Wave's Index.
    
    Dim iLoop As Integer
    Dim iResult As Integer

    On Error GoTo UWE

    If giNumSounds = 0 Or piIndex < 0 Or piIndex > (giNumSounds - 1) Then
	Exit Function
    End If
    
    If gtSI(piIndex).Handle <> 0 Then
	' Free the memory that's holding the wave
	iResult = GlobalUnlock(gtSI(piIndex).UnlockHandle)
	iResult = GlobalFree(gtSI(piIndex).UnlockHandle)
	
	' Remove the sound Index!
	gtSI(piIndex).Handle = 0
	gtSI(piIndex).UnlockHandle = 0
	gtSI(piIndex).FileName = ""
	
	giNumSounds = giNumSounds - 1
	
	dwsUnloadWave = True
    End If

UWER:
    Exit Function
    
UWE:
    MsgBox "Error '" + Error + "' occurred in DWSTEST:dwsUnloadLoadWave!"
    Resume UWER
End Function

