'******************************************************************************
' File:      dws.bas
' Version:   1.00
' Tab stops: every 2 columns
' Project:   DiamondWare's Sound ToolKit for Windows
' Copyright: 1994-1996 DiamondWare, Ltd.  All rights reserved.
' Written:   96/03/20 by David Allen
' Purpose:   Contains declarations for the DW Sound ToolKit for Windows
' History:   96/03/28 KW & JCL finalized for 1.0
'            96/04/14 JCL finalized for 1.01
'            96/05/13 JCL finalized for 1.1 (no changes)
'******************************************************************************



Attribute VB_Name = "DWS"
Option Explicit


' If a call to a dws_ function returns 0 (FALSE), then this is an
' indication that an error has occured.  Call dws_ErrNo to see which
' one.  The following series of Public Consts is the complete list of
' possible return values for dws_ErrNo.
Public Const dws_EZERO = 0   ' no error

' The following 8 errors may be triggered by any dws_ function
Public Const dws_NOTINITTED = 1
Public Const dws_ALREADYINITTED = 2
Public Const dws_NOTSUPPORTED = 3
Public Const dws_INTERNALERROR = 4
Public Const dws_INVALIDPOINTER = 5
Public Const dws_RESOURCEINUSE = 6
Public Const dws_MEMORYALLOCFAILED = 7
Public Const dws_SETEVENTFAILED = 8

' dws_BUSY may be triggered during a call to a dws_ function, if any
' dws_ function is already executing.  Ordinarily, this should never
' occur.
Public Const dws_BUSY = 9

' This error may be triggered only by dws_Init 
Public Const dws_Init_BUFTOOSMALL = 101

' The following 3 errors may be triggered by any dws_D (dig) function
Public Const dws_D_NOTADWD = 201
Public Const dws_D_NOTSUPPORTEDVER = 202
Public Const dws_D_BADDPLAY = 203

' The following error may be triggered by dws_DPlay
Public Const dws_DPlay_NOSPACEFORSOUND = 251

' These 2 errors may be triggered by dws_WAV2DWD
Public Const dws_WAV2DWD_NOTAWAVE = 301
Public Const dws_WAV2DWD_UNSUPPORTEDFORMAT = 302

' The following error may be triggered by any dws_M (music) function '
Global Const dws_M_BADMPLAY = 401

'---------------------------------------------------------------------------
' This section Public Consts bitfields which are used by various dws_
' functions.  Each bit in a bitfield, by definition, may be set/reset
' independently of all other bits.
'

' flags for muscaps value of dws_DETECTRESULTS structure
Public Const dws_muscap_NONE = &H0 ' no music playback
Public Const dws_muscap_MIDIPORT = &H1 ' output port
Public Const dws_muscap_SYNTH = &H2 ' generic int synth
Public Const dws_muscap_SQSYNTH = &H4 ' square wave int synth
Public Const dws_muscap_FMSYNTH = &H8 ' FM int synth
Public Const dws_muscap_MAPPER = &H10 ' MIDI mapper
Public Const dws_muscap_ANY = &H1F ' mask of all available modes

Public Const dws_digcap_NONE = &H0 ' no digitized sound playback
Public Const dws_digcap_11025_08_1 = &H1 ' 11kHz, 8-bit, mono
Public Const dws_digcap_11025_08_2 = &H2 ' 11kHz, 8-bit, stereo
Public Const dws_digcap_11025_16_1 = &H4 ' 11kHz, 16-bit, mono
Public Const dws_digcap_11025_16_2 = &H8 ' 11kHz, 16-bit, stereo
Public Const dws_digcap_22050_08_1 = &H10 ' 22kHz, 8-bit, mono
Public Const dws_digcap_22050_08_2 = &H20 ' 22kHz, 8-bit, stereo
Public Const dws_digcap_22050_16_1 = &H40 ' 22kHz, 16-bit, mono
Public Const dws_digcap_22050_16_2 = &H80 ' 22kHz, 16-bit, stereo
Public Const dws_digcap_44100_08_1 = &H100 ' 44kHz, 8-bit, mono
Public Const dws_digcap_44100_08_2 = &H200 ' 44kHz, 8-bit, stereo
Public Const dws_digcap_44100_16_1 = &H400 ' 44kHz, 16-bit, mono
Public Const dws_digcap_44100_16_2 = &H800 ' 44kHz, 16-bit, stereo
Public Const dws_digcap_ANY = &HFFF ' mask of all available modes

' The following Public Consts are bitfields used in the flags field in the
' dws_IDEAL struct.
'
' SWAPLR should be used to compensate for downstream electronics which
' switch the left and right field.
'
' Since pitch and volume change both require some additional CPU time,
' you may want to disable them for slow machines and enable for fast
' machines.  This is an easy way for you to do this, without changing
' your program around.
'
' Notes:
'   1) Pitch change is slower than volume change.
'   2) Pitch decrease (dws_DPLAY.pitch > dws_IDENTITY) is slower than
'      pitch increase
'   3) When the source sound, or the STK, is 8-bit, raising the volume
'      is slower than lowering it.  Otherwise both are equal.
'
Public Const dws_ideal_NONE = &H0            ' this is the normal case
Public Const dws_ideal_SWAPLR = &H1          ' swap Left & Right on playback
Public Const dws_ideal_DISABLEPITCH = &H2    ' disable the pitch feature
Public Const dws_ideal_DISABLEVOLUME = &H4   ' disable the volume feature
Public Const dws_ideal_MAXSPEED = &H6        ' use this for very slow machines

' These are the flag bitfields for the dws_DPLAY structure.
' Each corresponds to one field in the struct.

Public Const dws_dplay_SND = &H1
Public Const dws_dplay_COUNT = &H2
Public Const dws_dplay_PRIORITY = &H4
Public Const dws_dplay_PRESND = &H8
Public Const dws_dplay_SOUNDNUM = &H10
Public Const dws_dplay_LVOL = &H20
Public Const dws_dplay_RVOL = &H40
Public Const dws_dplay_PITCH = &H80
Public Const dws_dplay_CALLBACK = &H100
Global Const dws_dplay_SYNCHRONOUS = &h200

' The following 2 consts indicate the status of music playback
Public Const dws_MSONGSTATUSPLAYING = &H1
Public Const dws_MSONGSTATUSPAUSED = &H2


'---------------------------------------------------------------------------
'
' When the WIN-STK sends a message to your window, the lParam field
' indicates the purpose of the message.
'
Public Const dws_event_SOUNDCOMPLETE = &H1
Global Const dws_event_SOUNDSTARTED = &H2
Global Const dws_event_SOUNDABORTED = &H3


' For no change in volume level or pitch
Public Const dws_IDENTITY = &H100

' Default priority, if not specified in call to dws_DPlay
Public Const dws_NORMALPRIORITY = &H1000

'***************************************************************************
'This section declares the struct types used by the STK.  In each
'case, the user must create an instance of the struct prior to making
'a call to any STK function which takes a pointer to it.  The STK does
'not keep a pointer to any of these structs internally; after the call
'returns, you may deallocate it, if you wish.
'
'NB: The STK _does_ keep pointers to digitized sound buffers!
'
'A pointer to this struct is passed to dws_DetectHardWare, which fills
'it in.  It should then be passed to dws_Init.  If you plan on writing
'this struct out to a file, it's important that you write the entire
'contents.  There is information (for internal STK use only) in the
'reserved[] field!

Type dws_DETECTRESULTS
    ' This field indicates which music capabilities are available, if any
    muscaps As Long              ' see dws_muscap_xxxxxx Public Consts above

    ' This field indicates which dig capabilities are available, if any
    digcaps As Long              ' see dws_digcaps_xxxxxx Public Consts above

    ' This field should be modified only with caution
    digbfr As Long               ' size of buffer required by smallest capabilities

    reserved(20) As Byte
End Type

' A pointer to this struct is passed as a parameter to dws_Init.  This
' struct allows the program to let the STK know what capabilities it
' will actually use.

Type dws_IDEAL
    flags As Long                ' use combination of dws_ideal_xxxx
    mustyp As Long               ' use dws_muscap_xxxxxx

    digtyp As Long               ' use dws_digcaps_xxxxxx (mode) to select
    dignvoices As Integer        ' maximum number of mixer channels to use (16 max)

    reserved(18) As Byte
End Type

' A pointer to this struct is passed to dws_DPlay.
'
' Note that the soundnum field is filled in by dws_DPlay as a return value.

Type dws_DPlay
    flags     As Long            ' flag word for active fields in struct
    snd       As Long            ' pointer to buffer which holds a .DWD file
    count     As Integer         ' number of times to play, or 0=infinite loop
    priority  As Integer         ' higher numbers mean higher priority
    presnd    As Integer         ' soundnum to sequence sound _after_
    soundnum  As Integer         ' dws_DPlay returns a snd number from 10-65535
    lvol      As Integer         ' 0-65535, 0 is off, 256 is dws_IDENTITY
    rvol      As Integer         ' if the output is mono lvol & rvol are averaged
    pitch     As Integer         ' 1-65535, 256 is dws_IDENTITY (0 is unuseable)
    dummy     As Integer         ' added to insure DWORD alignment
    
    #If Win32 Then
        hwndmsg As Long          ' handle of window to which to send msg
        message As Long          ' message number to send to hwndmsg
        reserved(16) As Byte     ' 32 bit overhead
    #Else
        hwndmsg As Integer       ' handle of window to which to send msg
        message As Integer       ' message number to send to hwndmsg
        reserved(20) As Byte     ' 16 bit overhead
    #End If
End Type

' A pointer to this struct is passed to dws_MPlay.
Type dws_MPlay
    track As String         ' pointer to buffer which holds a null terminated .MID file name
    count As Integer        ' number of times to play, or 0=infinite loop

    reserved(10) As Byte

End Type

'***************************************************************************

#If Win32 Then
    ' 32-bit Information/Types/Declarations

    ' This function is callable at any time.  It returns the number of the
    ' last error which occured.

    Declare Function dws_ErrNo Lib "DWSW32.DLL" () As Integer
     
    ' Each function in this section has a boolean return value.    A 0 (false)
    ' indicates that the function failed in some way.  In this case, call
    ' dws_ErrNo to get the specific error.  Otherwise, a return value of 1
    ' (true) indicates that all is well.
    
    Declare Function dws_DetectHardWare Lib "DWSW32.DLL" (dws_Type As dws_DETECTRESULTS) As Integer

    Declare Function dws_Init Lib "DWSW32.DLL" (dws_Type As dws_DETECTRESULTS, dws_ID As dws_IDEAL) As Integer
    
    ' If the program has called dws_Init, it _MUST_ call dws_Kill before it
    ' terminates.

    Declare Function dws_Kill Lib "DWSW32.DLL" () As Integer
 
    ' The following function is the digital mixer of the STK.  A
    ' value of 0 is off; dws_IDENTITY is normal, and 0xffff is maximum
    ' volume (grossly distorted).

    Declare Function dws_XDig Lib "DWSW32.DLL" (ByVal lVolume As Integer, ByVal rVolume As Integer) As Integer
    
    ' The following 9 functions comprise the digitized sound functions of
    ' the STK.  See the documentation for complete details.

    Declare Function dws_DPlay Lib "DWSW32.DLL" (dws_DP As dws_DPlay) As Integer

    ' Allows you to change the following items:
    '   count
    '   priority
    '   lvol
    '   rvol
    '   pitch
    '   hwndmsg and message (simultaneously)

    Declare Function dws_DSetInfo Lib "DWSW32.DLL" (dws_DP As dws_DPlay, dwsDP2 As Any) As Integer

    ' Can retrieve the current values for any or all of the following:
    '   snd
    '   count
    '   priority
    '   presnd
    '   lvol
    '   rvol
    '   pitch
    '   hwndmsg and message (simultaneously)

    Declare Function dws_DGetInfo Lib "DWSW32.DLL" (dws_DP As dws_DPlay, dwsDP2 As Any) As Integer
    
    ' Callable at any time--even before dws_Init or after dws_Kill
    Declare Function dws_DGetRateFromDWD Lib "DWSW32.DLL" (snd As Long, Result As Integer) As Integer

    Declare Function dws_DDiscard Lib "DWSW32.DLL" (ByVal soundnum As Integer) As Integer

    Declare Function dws_DDiscardAO Lib "DWSW32.DLL" (snd As Long) As Integer

    Declare Function dws_DClear Lib "DWSW32.DLL" () As Integer

    Declare Function dws_DPause Lib "DWSW32.DLL" () As Integer

    Declare Function dws_DUnPause Lib "DWSW32.DLL" () As Integer

    ' Converts a .WAV buffer to a .DWD buffer
    '
    ' This function has two usages.  In the first, pass the wave pointer, the
    ' wave length in *len and a NULL pointer for dwd.  The routine will return
    ' the length of the buffer required to hold the resulting DWD in *len.  In
    ' the second usage, allocate a buffer of the correct size and pass its
    ' address in dwd.  Make sure you pass the wave pointer in wave and the size
    ' of the wave in *len.  It will then perform the conversion, returning the
    ' number of bytes used in *len.

    Declare Function dws_WAV2DWD Lib "DWSW32.DLL" (wave As Long, length As Long, snd As Long) As Integer

    ' The following 5 functions comprise the music functions of the STK. */
    Declare Function dws_MPlay Lib "DWSW32.DLL" (dws_MP As dws_MPlay) As Integer

    Declare Function dws_MSongStatus Lib "DWSW32.DLL" (Result As Integer) As Integer

    Declare Function dws_MClear Lib "DWSW32.DLL" () As Integer

    Declare Function dws_MPause Lib "DWSW32.DLL" () As Integer

    Declare Function dws_MUnPause Lib "DWSW32.DLL" () As Integer
    
    ' If your 16-bit application can't yield CPU time to the system, it must
    ' call this function periodically to prevent the sound from pausing.
    ' This is not required for 32-bit applications, but the function is
    ' supported for compatibility.

    Declare Function dws_Update Lib "DWSW32.DLL" () As Integer ' Affects all sounds

#ElseIf Win16 Then
    ' 16-bit Information/Types/Declarations
     
    ' This function is callable at any time.  It returns the number of the
    ' last error which occured.

    Declare Function dws_ErrNo Lib "DWSW16.DLL" () As Integer
     
    ' Each function in this section has a boolean return value.    A 0 (false)
    ' indicates that the function failed in some way.  In this case, call
    ' dws_ErrNo to get the specific error.  Otherwise, a return value of 1
    ' (true) indicates that all is well.
    
    Declare Function dws_DetectHardWare Lib "DWSW16.DLL" (dws_Type As dws_DETECTRESULTS) As Integer

    Declare Function dws_Init Lib "DWSW16.DLL" (dws_Type As dws_DETECTRESULTS, dws_ID As dws_IDEAL) As Integer
    
    ' If the program has called dws_Init, it _MUST_ call dws_Kill before it
    ' terminates.
    
    Declare Function dws_Kill Lib "DWSW16.DLL" () As Integer
 
    ' The following function is the digital mixer of the STK.  A
    ' value of 0 is off; dws_IDENTITY is normal, and 0xffff is maximum
    ' volume (grossly distorted).

    Declare Function dws_XDig Lib "DWSW16.DLL" (ByVal lVolume As Integer, ByVal rVolume As Integer) As Integer
    
    ' The following 9 functions comprise the digitized sound functions of
    ' the STK.  See the documentation for complete details.

    Declare Function dws_DPlay Lib "DWSW16.DLL" (dws_DP As dws_DPlay) As Integer

    ' Allows you to change the following items:
    '   count
    '   priority
    '   lvol
    '   rvol
    '   pitch
    '   hwndmsg and message (simultaneously)

    Declare Function dws_DSetInfo Lib "DWSW16.DLL" (dws_DP As dws_DPlay, dwsDP2 As Any) As Integer

    ' Can retrieve the current values for any or all of the following:
    '   snd
    '   count
    '   priority
    '   presnd
    '   lvol
    '   rvol
    '   pitch
    '   hwndmsg and message (simultaneously)

    Declare Function dws_DGetInfo Lib "DWSW16.DLL" (dws_DP As dws_DPlay, dwsDP2 As Any) As Integer
    
    ' Callable at any time--even before dws_Init or after dws_Kill
    Declare Function dws_DGetRateFromDWD Lib "DWSW16.DLL" (snd As Long, Result As Integer) As Integer

    Declare Function dws_DDiscard Lib "DWSW16.DLL" (ByVal soundnum As Integer) As Integer

    Declare Function dws_DDiscardAO Lib "DWSW16.DLL" (snd As Long) As Integer

    Declare Function dws_DClear Lib "DWSW16.DLL" () As Integer

    Declare Function dws_DPause Lib "DWSW16.DLL" () As Integer

    Declare Function dws_DUnPause Lib "DWSW16.DLL" () As Integer

    ' Converts a .WAV buffer to a .DWD buffer
    '
    ' This function has two usages.  In the first, pass the wave pointer, the
    ' wave length in *len and a NULL pointer for dwd.  The routine will return
    ' the length of the buffer required to hold the resulting DWD in *len.  In
    ' the second usage, allocate a buffer of the correct size and pass its
    ' address in dwd.  Make sure you pass the wave pointer in wave and the size
    ' of the wave in *len.  It will then perform the conversion, returning the
    ' number of bytes used in *len.

    Declare Function dws_WAV2DWD Lib "DWSW16.DLL" (wave As Long, length As Long, snd As Long) As Integer

    ' The following 5 functions comprise the music functions of the STK. */
    Declare Function dws_MPlay Lib "DWSW16.DLL" (dws_MP As dws_MPlay) As Integer

    Declare Function dws_MSongStatus Lib "DWSW16.DLL" (Result As Integer) As Integer

    Declare Function dws_MClear Lib "DWSW16.DLL" () As Integer

    Declare Function dws_MPause Lib "DWSW16.DLL" () As Integer

    Declare Function dws_MUnPause Lib "DWSW16.DLL" () As Integer
    
    ' If your 16-bit application can't yield CPU time to the system, it must
    ' call this function periodically to prevent the sound from pausing.
    ' This is not required for 32-bit applications, but the function is
    ' supported for compatibility.

    Declare Function dws_Update Lib "DWSW16.DLL" () As Integer ' Affects all sounds

#End If
