/*
    Copyright (C) 1998, 1999 by Serguei 'Snaar' Narojnyi
    Copyright (C) 1998, 1999 by Jorrit Tyberghein
    Written by Serguei 'Snaar' Narojnyi

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __NETWORK_MAN_SIMPLE_H__
#define __NETWORK_MAN_SIMPLE_H__

// NETWORK.H
// csNetworkManagerSimple class.

#include "cscom/com.h"
#include "csnetman/simple/mansdefs.h"
#include "inetman.h"
#include "inetdrv.h"

extern const CLSID CLSID_SimpleNetworkManager;

///
class csNetworkManagerSimple : public INetworkManager
{
protected:
	INetworkDriver *piNetDrv;

	DWORD dwLastError;

	unsigned short iMaxPlayers;
	unsigned short iCurPlayers;

	DWORD dwListeningSocketID;
	DWORD dwClientSocketID;
	DWORD dwServerSocketID[CS_NET_MAN_MAX_SOCKETS];

/*	bool bListeningSocketSpawned;
	bool bClientSocketSpawned;
	bool bServerSocketSpawned[CS_NET_MAN_MAX_SOCKETS];*/

	bool bListening;
	bool bConnectedToServer;
	bool bServerSocketConnected[CS_NET_MAN_MAX_SOCKETS];

	bool bJustConnected[CS_NET_MAN_MAX_SOCKETS];

	bool bNewConnections;

	time_t ConnectionTime[CS_NET_MAN_MAX_SOCKETS];

	void SysPrintf(int mode, char* str, ...);

	PLAINMESSAGE messagequeue[512];
	
	int iCurMessage;

	int iLastMessage;

	bool bNewMessages;

	DWORD SendMsg(DWORD dwSocketID, MSGHDR *lpmsghdr, char *buf);

	DWORD RecvMsg(DWORD dwSocketID, MSGHDR *lpmsghdr, char *buf);

	DWORD CheckForIncomingConnections();

	DWORD ProceedNewConnections();

	DWORD ParseIncomingFromClients();

	DWORD ParseIncomingFromServer();

	DWORD ParsePlainMsg(char *msg, unsigned short msgsize, bool fromclient, unsigned short src);

	unsigned short CalculateCRC(char *buf, int n);

	DWORD AddMessageToQueue(PLAINMSGHDR *hdr, char *body);

	DWORD ReadMessage(PLAINMSGHDR *hdr, char *body);


public:
	/// The System interface. 
	ISystem* m_piSystem;

	csNetworkManagerSimple(ISystem* piSystem);

	virtual ~csNetworkManagerSimple();

	STDMETHODIMP Open();

	STDMETHODIMP Close();

	STDMETHODIMP DoFrame();

	/// Game management
	STDMETHODIMP CreateGame(unsigned short iNumOfPlayers);

	STDMETHODIMP KillGame();

	STDMETHODIMP JoinGame();

	STDMETHODIMP LeaveGame();

	STDMETHODIMP EnumerateGames();

	STDMETHODIMP GetGameData();

	STDMETHODIMP SetGameData();

	/// Player management
	STDMETHODIMP CreatePlayer();

	STDMETHODIMP KillPlayer();

	STDMETHODIMP GetPlayerData();

	STDMETHODIMP SetPlayerData();

	STDMETHODIMP AddPlayerToGroup();

	STDMETHODIMP RemovePlayerFromGroup();

	/// Group management
	STDMETHODIMP CreateGroup();

	STDMETHODIMP KillGroup();

	STDMETHODIMP GetGroupData();

	STDMETHODIMP SetGroupData();

	/// Message management
	STDMETHODIMP Send();

	STDMETHODIMP Receive();

	STDMETHODIMP GetMessageCount();

	STDMETHODIMP PeekMessage();

	/// Utility stuff
	STDMETHODIMP GetLastError();

	STDMETHODIMP GetCaps();

	DECLARE_IUNKNOWN()
	DECLARE_INTERFACE_TABLE(csNetworkManagerSimple)
};

///
class csNetworkManagerSimpleFactory : public INetworkManagerFactory
{
  ///
  STDMETHODIMP CreateInstance (REFIID riid, ISystem * piSystem, void **ppv);

  /// Lock or unlock from memory.
  STDMETHODIMP LockServer (COMBOOL bLock);

  DECLARE_IUNKNOWN ()
  DECLARE_INTERFACE_TABLE (csNetworkManagerSimpleFactory)
};

#endif	//__NETWORK_MAN_SIMPLE_H__
