# This is a subinclude file used to define the rules needed
# to build the NULL network driver

# Driver description
DESCRIPTION.netmans = Crystal Space simple network manager

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Driver-specific help commands
DRVHELP += $(NEWLINE)echo $"  make netmans      Make the $(DESCRIPTION.netmans)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: netmans

all drivers netdrivers: netmans

netmans:
	$(MAKE_TARGET) MAKE_DLL=yes

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp libs/csnetman/simple

# The NULL Network driver
ifeq ($(USE_DLL),yes)
  NETMANS=$(OUTDLL)netmans$(DLL)
  DEP.NETMANS=$(CSCOM.LIB) $(CSSYS.LIB) $(CSUTIL.LIB)
else
  NETMANS=$(OUT)$(LIB_PREFIX)netmans$(LIB)
  DEP.EXE+=$(NETMANS)
  CFLAGS.STATIC_COM+=$(CFLAGS.D)SCL_NETMANSIMPLE
endif
DESCRIPTION.$(NETMANS) = $(DESCRIPTION.netmans)
SRC.NETMANS = $(wildcard libs/csnetman/simple/*.cpp)
OBJ.NETMANS = $(addprefix $(OUT),$(notdir $(SRC.NETMANS:.cpp=$O)))

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: netmans netmansclean netmanscleanlib

# Chain rules
net: netmans
clean: netmansclean
cleanlib: netmanscleanlib

netmans: $(OUTDIRS) $(NETMANS)

$(NETMANS): $(OBJ.NETMANS) $(DEP.NETMANS)
	$(DO.LIBRARY)

netmansclean:
	$(RM) $(NETMANS)

netmanscleanlib:
	$(RM) $(OBJ.NETMANS) $(NETMANS)

ifdef DO_DEPEND
depend: $(OUTOS)netmans.dep
$(OUTOS)netmans.dep: $(SRC.NETMANS)
	$(DO.DEP)
else
-include $(OUTOS)netmans.dep
endif

endif # ifeq ($(MAKESECTION),targets)
