/*
	Copyright (C) 1998, 1999 by Serguei 'Snaar' Narojnyi
	Copyright (C) 1998, 1999 by Jorrit Tyberghein
	Written by Serguei 'Snaar' Narojnyi

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __NETWORK_MANAGER_NULL_H__
#define __NETWORK_MANAGER_NULL_H__

// NETWORK.H
// csNetworkManagerNull class.

#include "cscom/com.h"
#include "csnetman/null/manndefs.h"
#include "inetman.h"

extern const CLSID CLSID_NullNetworkManager;

class csNetworkManagerNull : public INetworkManager
{
protected:

public:
	csNetworkManagerNull(ISystem* piSystem);

	virtual ~csNetworkManagerNull();

	STDMETHODIMP Open();

	STDMETHODIMP Close();

	STDMETHODIMP DoFrame();

	/// Game management
	STDMETHODIMP CreateGame(unsigned short iNumOfPlayers);

	STDMETHODIMP KillGame();

	STDMETHODIMP JoinGame();

	STDMETHODIMP LeaveGame();

	STDMETHODIMP EnumerateGames();

	STDMETHODIMP GetGameData();

	STDMETHODIMP SetGameData();

	/// Player management
	STDMETHODIMP CreatePlayer();

	STDMETHODIMP KillPlayer();

	STDMETHODIMP GetPlayerData();

	STDMETHODIMP SetPlayerData();

	STDMETHODIMP AddPlayerToGroup();

	STDMETHODIMP RemovePlayerFromGroup();

	/// Group management
	STDMETHODIMP CreateGroup();

	STDMETHODIMP KillGroup();

	STDMETHODIMP GetGroupData();

	STDMETHODIMP SetGroupData();

	/// Message management
	STDMETHODIMP Send();

	STDMETHODIMP Receive();

	STDMETHODIMP GetMessageCount();

	STDMETHODIMP PeekMessage();

	/// Utility stuff
	STDMETHODIMP GetLastError();

	STDMETHODIMP GetCaps();

	DECLARE_IUNKNOWN()
	DECLARE_INTERFACE_TABLE(csNetworkManagerNull)
};

class csNetworkManagerNullFactory : public INetworkManagerFactory
{
    STDMETHODIMP CreateInstance(REFIID riid, ISystem* piSystem, void** ppv);

    /// Lock or unlock from memory.
    STDMETHODIMP LockServer(COMBOOL bLock);

    DECLARE_IUNKNOWN()
    DECLARE_INTERFACE_TABLE(csNetworkManagerNullFactory)
};


#endif	//__NETWORK_MANAGER_NULL_H__

