/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gutil.h"

void DisplayFXTextpattern (IGraphics3D* piG3D, ITextureHandle *handle)
{
  G3DPolygonDPFX poly;

  memset(&poly,0,sizeof(poly));
  poly.num=4;

  piG3D->SetRenderState (G3DRENDERSTATE_ZBUFFERTESTENABLE, false);
  piG3D->SetRenderState (G3DRENDERSTATE_ZBUFFERFILLENABLE, true);

  poly.txt_handle     = handle;
  poly.vertices[0].sx = 10;
  poly.vertices[0].sy = 10;
  poly.vertices[1].sx = 10;
  poly.vertices[1].sy = 80;
  poly.vertices[2].sx = 80;
  poly.vertices[2].sy = 80;
  poly.vertices[3].sx = 80;
  poly.vertices[3].sy = 10;
  poly.vertices[0].u=0;
  poly.vertices[0].v=1;
  poly.vertices[1].u=0;
  poly.vertices[1].v=0;
  poly.vertices[2].u=1;
  poly.vertices[2].v=0;
  poly.vertices[3].u=1;
  poly.vertices[3].v=1;

  for(int j=0;j<4;j++)
  {
    poly.vertices[j].r=1;
    poly.vertices[j].g=1;
    poly.vertices[j].b=1;

    // Environment mapping.
    poly.vertices[j].z=10;
  }

  piG3D->StartPolygonFX (handle, CS_FX_TRANSPARENT);
  piG3D->DrawPolygonFX (poly);
  piG3D->FinishPolygonFX ();

  int i = 0;
  for (i = 0; i<4; i++) poly.vertices[i].sx += 90;

  piG3D->StartPolygonFX (handle, CS_FX_ADD);
  piG3D->DrawPolygonFX (poly);
  piG3D->FinishPolygonFX ();

  for (i = 0; i<4; i++) poly.vertices[i].sx += 90;

  piG3D->StartPolygonFX (handle, CS_FX_MULTIPLY);
  piG3D->DrawPolygonFX (poly);
  piG3D->FinishPolygonFX ();

  for (i = 0; i<4; i++) poly.vertices[i].sx += 90;

  piG3D->StartPolygonFX (handle, CS_FX_MULTIPLY2);
  piG3D->DrawPolygonFX (poly);
  piG3D->FinishPolygonFX ();

  for (i = 0; i<4; i++) poly.vertices[i].sx += 90;

  piG3D->StartPolygonFX (handle, CS_FX_SETALPHA (0.25));
  piG3D->DrawPolygonFX (poly);
  piG3D->FinishPolygonFX ();

  for (i = 0; i<4; i++) poly.vertices[i].sx += 90;

  piG3D->StartPolygonFX(handle, CS_FX_SETALPHA (0.5));
  piG3D->DrawPolygonFX(poly);
  piG3D->FinishPolygonFX();

  for (i = 0; i<4; i++) poly.vertices[i].sx += 90;

  piG3D->StartPolygonFX (handle, CS_FX_SETALPHA (0.75));
  piG3D->DrawPolygonFX (poly);
  piG3D->FinishPolygonFX ();
}

void WriteChar (IGraphics3D *piG3D, ITextureHandle *handle, int x1, int y1,
  int x2, int y2, RGBcolor topcolor, RGBcolor bottomcolor, char c)
{
  static const char* FontChar = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ<|>!$%&/\\\"()=?'+-.,:;*~{[]} ";

  const char* s = strchr(FontChar, c);
  if (s==NULL) return;

  int pos = s-FontChar;
  int cx = pos & 0x07;
  int cy = pos >> 3;

  G3DPolygonDPFX poly;

  memset(&poly,0,sizeof(poly));
  poly.num=4;

  poly.txt_handle     = handle;
  poly.vertices[0].sx = x1;
  poly.vertices[0].sy = y1;
  poly.vertices[1].sx = x1;
  poly.vertices[1].sy = y2;
  poly.vertices[2].sx = x2;
  poly.vertices[2].sy = y2;
  poly.vertices[3].sx = x2;
  poly.vertices[3].sy = y1;

  float tx0 = (float) cx   *0.125;
  float tx1 = (float)(cx+1)*0.125;
  float ty0 = (float) cy   *0.125;
  float ty1 = (float)(cy+1)*0.125;

  poly.vertices[0].u=tx0;
  poly.vertices[0].v=ty1;
  poly.vertices[1].u=tx0;
  poly.vertices[1].v=ty0;
  poly.vertices[2].u=tx1;
  poly.vertices[2].v=ty0;
  poly.vertices[3].u=tx1;
  poly.vertices[3].v=ty1;

  const float colorfactor = 1.0f/255.0f;

  poly.vertices[1].r=topcolor.red*  colorfactor;
  poly.vertices[1].g=topcolor.green*colorfactor;
  poly.vertices[1].b=topcolor.blue* colorfactor;
  poly.vertices[2].r=topcolor.red*  colorfactor;
  poly.vertices[2].g=topcolor.green*colorfactor;
  poly.vertices[2].b=topcolor.blue* colorfactor;
  poly.vertices[0].r=bottomcolor.red*  colorfactor;
  poly.vertices[0].g=bottomcolor.green*colorfactor;
  poly.vertices[0].b=bottomcolor.blue* colorfactor;
  poly.vertices[3].r=bottomcolor.red*  colorfactor;
  poly.vertices[3].g=bottomcolor.green*colorfactor;
  poly.vertices[3].b=bottomcolor.blue* colorfactor;

  for(int j=0;j<4;j++)
  {
    poly.vertices[j].z=100;
  }

  piG3D->DrawPolygonFX(poly);
}

void WriteText (IGraphics3D* piG3D, ITextureHandle *handle,
  int x, int y, int w, int h, int fontadjust,
  RGBcolor topcolor, RGBcolor bottomcolor, UInt mixmode, const char* text)
{
  long ztest, zfill;
  piG3D->GetRenderState(G3DRENDERSTATE_ZBUFFERTESTENABLE, ztest);
  piG3D->GetRenderState(G3DRENDERSTATE_ZBUFFERFILLENABLE, zfill);
  piG3D->SetRenderState(G3DRENDERSTATE_ZBUFFERTESTENABLE, false);
  piG3D->SetRenderState(G3DRENDERSTATE_ZBUFFERFILLENABLE, false);

  int len        = strlen(text);
  int TotalWidth = len * w;
  int CurrentX = x-TotalWidth/2;

  piG3D->StartPolygonFX (handle, mixmode | CS_FX_GOURAUD);

  while(*text)
  {
    WriteChar (piG3D, handle, CurrentX - fontadjust, y,
      CurrentX + w + fontadjust, y + h, topcolor, bottomcolor, *text);
    text++;
    CurrentX += w;
  }

  piG3D->FinishPolygonFX ();

  piG3D->SetRenderState(G3DRENDERSTATE_ZBUFFERTESTENABLE, ztest);
  piG3D->SetRenderState(G3DRENDERSTATE_ZBUFFERFILLENABLE, zfill);
}

void WriteShandowText (IGraphics3D* piG3D, ITextureHandle *FontHandle,
  ITextureHandle *ShadowHandle, int x, int y, int w, int h, int fontadjust,
  int shadowoffsetx, int shadowoffsety, RGBcolor topcolor, RGBcolor bottomcolor,
  const char* text)
{
  WriteText(piG3D, ShadowHandle, x+shadowoffsetx, y-shadowoffsety, w, h, fontadjust, 
            RGBcolor(255,255,255), RGBcolor(255,255,255), 
            CS_FX_MULTIPLY, text);
  WriteText(piG3D, FontHandle, x, y, w, h, fontadjust, 
            topcolor, bottomcolor,
            CS_FX_SETALPHA (0.0) | CS_FX_KEYCOLOR, text);
}
