/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/glight.h"


geLight::geLight(geContainer* pContainer)
  : inherited(pContainer)
{
  m_pLight       = NULL;
}

void geLight::Create(gePosition Pos, float radius, float r, float g, float b)
{
  ASSERT(m_pLight == NULL); //Only create once!

  csVector3 V = Pos.GetPosition();
  CHK (m_pLight = new csDynLight (V.x, V.y, V.z, radius, r, g, b));
  m_pWorld->GetCsWorld()->AddDynLight (m_pLight);

  SetPosition(Pos);
}

geLight::~geLight()
{
  if (m_pLight)
  {
    m_pWorld->GetCsWorld()->RemoveDynLight(m_pLight);
  }
  delete m_pLight;
}


void geLight::OnMove(gePosition /*OldPos*/)
{
  ASSERT(m_pLight); //Call Create() first, before moving around!

  csVector3 Pos = m_Pos;
  m_pLight->Move(m_Pos.GetSector(), Pos);
  m_pLight->Setup();
}

void geLight::SetColor (float r, float g, float b)
{
  ASSERT(m_pLight); //Call Create() first!
  
  m_pLight->SetColor(csColor(r,g,b));
  m_pLight->Setup();
}

void geLight::SetRadius(float radius)
{
  ASSERT(m_pLight); //Call Create() first!
  
  m_pLight->Resize(radius);
  m_pLight->Setup();
}
