/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gbullet.h"

geBullet::geBullet(geContainer* pContainer)
  : inherited(pContainer)

{
  m_pLight  = new geLight   (this);
  m_pSprite = new geSprite3D(this);
  m_Damage  = 10;
}

geBullet::~geBullet()
{
  if (m_pLight)  m_pLight->Destroy();
  if (m_pSprite) m_pSprite->Destroy();
}

void geBullet::Create(gePosition Pos, const char* SpriteName, const char* ActionName, int damage)
{
  m_pLight-> Create(Pos, 3, 3.0, 0, 0);
  m_pSprite->Create(Pos, SpriteName, ActionName);
  m_Damage = damage;
  SetPosition(Pos);
}

void geBullet::Destroy()
{
  inherited::Destroy();
  m_pLight->Destroy();
  m_pLight=NULL;
  m_pSprite->Destroy();
  m_pSprite=NULL;
}

void geBullet::OnMove(gePosition /*OldPos*/)
{
  m_pLight-> SetPosition(m_Pos);
  m_pSprite->SetPosition(m_Pos);
}

void geBullet::OnCollision(gePhysicalObject* pOther) 
{
  if (pOther)
  {
    pOther->Hit(m_Damage, this);
  }

  Explode();
}

void geBullet::Explode()
{
  Destroy();
  geExplosion* pExplosion = new geExplosion(m_pWorld);
  pExplosion->Create(m_Pos, 5);
}
