/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gbeing.h"

geBeing::geBeing(geContainer* pContainer)
 : inherited(pContainer)
{
  m_Health = 100;
  m_Alive  = true;
}

geBeing::~geBeing()
{
}

void geBeing::Hit(int Damage, gePhysicalObject* pHitObject)
{
  if (IsAlive())
  {
    m_Health -= Damage;
    if (m_Health <= 0)
    {
      m_Alive = false;
      Die(pHitObject);
    }
  }
}

void geBeing::Die(gePhysicalObject* /*pLastHitObject*/)
{
}

