# Library description
DESCRIPTION.csgame = Crystal Shooter game library

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Library-specific help commands
LIBHELP += $(NEWLINE)echo $"  make csgame       Make the $(DESCRIPTION.csgame)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: csgame

all libs: csgame
csgame:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp libs/csgame

CSGAME.LIB = $(OUT)$(LIB_PREFIX)csgame$(LIB)
SRC.CSGAME = $(wildcard libs/csgame/*.cpp)
OBJ.CSGAME = $(addprefix $(OUT),$(notdir $(SRC.CSGAME:.cpp=$O)))

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: csgame csgameclean

all: $(CSGAME.LIB)
csgame: $(OUTDIRS) $(CSGAME.LIB)
clean: csgameclean

$(CSGAME.LIB): $(OBJ.CSGAME)
	$(DO.STATIC.LIBRARY)

csgameclean:
	-$(RM) $(CSGEOM.LIB)

ifdef DO_DEPEND
depend: $(OUTOS)csgame.dep
$(OUTOS)csgame.dep: $(SRC.CSGAME)
	$(DO.DEP)
else
-include $(OUTOS)csgame.dep
endif

endif # ifeq ($(MAKESECTION),targets)
