# Library description
DESCRIPTION.cscom = Crystal Space cross-platform COM library

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Library-specific help commands
LIBHELP += $(NEWLINE)echo $"  make cscom        Make the $(DESCRIPTION.cscom)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: cscom

all libs: cscom
cscom:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp libs/cscom

CSCOM.LIB = $(OUT)$(LIB_PREFIX)cscom$(LIB)
SRC.CSCOM = $(wildcard libs/cscom/*.cpp)
OBJ.CSCOM = $(addprefix $(OUT),$(notdir $(SRC.CSCOM:.cpp=$O)))

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: cscom cscomclean

all: $(CSCOM.LIB)
cscom: $(OUTDIRS) $(CSCOM.LIB)
clean: cscomclean

$(CSCOM.LIB): $(OBJ.CSCOM)
	$(DO.STATIC.LIBRARY)

cscomclean:
	-$(RM) $(CSCOM.LIB)

ifdef DO_DEPEND
depend: $(OUTOS)cscom.dep
$(OUTOS)cscom.dep: $(SRC.CSCOM)
	$(DO.DEP)
else
-include $(OUTOS)cscom.dep
endif

endif # ifeq ($(MAKESECTION),targets)
