# This is a subinclude file used to define the rules needed
# to build the 3D software rendering driver -- soft

# Driver description
DESCRIPTION.soft = Crystal Space software renderer

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Driver-specific help commands
DRVHELP += $(NEWLINE)echo $"  make soft         Make the $(DESCRIPTION.soft)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: soft

all drivers drivers3d: soft

soft:
	$(MAKE_TARGET) MAKE_DLL=yes

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp libs/cs3d/software

ifeq ($(USE_DLL),yes)
  SOFT3D=$(OUTDLL)softrndr$(DLL)
  DEP.SOFT3D=$(CSCOM.LIB) $(CSGEOM.LIB) $(CSGFXLDR.LIB) $(CSUTIL.LIB) $(CSSYS.LIB)
else
  SOFT3D=$(OUT)$(LIB_PREFIX)soft$(LIB)
  DEP.EXE+=$(SOFT3D)
  CFLAGS.STATIC_COM+=$(CFLAGS.D)SCL_SOFT3D
endif
DESCRIPTION.$(SOFT3D) = $(DESCRIPTION.soft)
SRC.SOFT3D = $(wildcard libs/cs3d/software/*.cpp) \
  libs/cs3d/common/txtmgr.cpp libs/cs3d/common/memheap.cpp \
  libs/cs3d/common/inv_cmap.cpp libs/cs3d/common/imgtools.cpp
ifeq ($(USE_NASM),yes)
SRC.SOFT3D += $(wildcard libs/cs3d/software/i386/*.asm)
endif
OBJ.SOFT3D = $(addprefix $(OUT),$(notdir $(subst .asm,$O,$(SRC.SOFT3D:.cpp=$O))))
NASMFLAGS.SOFT3D = -i./libs/cs3d/software/i386/

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: soft softclean softcleanlib

# Chain rules
all: $(SOFT3D)
clean: softclean
cleanlib: softcleanlib

soft: $(OUTDIRS) $(SOFT3D)

# Extra dependencies not generated by "make depend"
$(OUT)scan8a$O: libs/cs3d/software/i386/cs.ash libs/cs3d/software/i386/scan.ash
$(OUT)scan16a$O: libs/cs3d/software/i386/cs.ash libs/cs3d/software/i386/scan.ash
$(OUT)scan32a$O: libs/cs3d/software/i386/cs.ash libs/cs3d/software/i386/scan.ash
$(OUT)cpuid$O: libs/cs3d/software/i386/cs.ash

$(OUT)%$O: libs/cs3d/software/i386/%.asm
	$(DO.COMPILE.ASM) $(NASMFLAGS.SOFT3D)

$(SOFT3D): $(OBJ.SOFT3D) $(DEP.SOFT3D)
	$(DO.LIBRARY)

softclean:
	$(RM) $(SOFT3D)

softcleanlib:
	$(RM) $(OBJ.SOFT3D) $(SOFT3D)

ifdef DO_DEPEND
depend: $(OUTOS)soft3d.dep
$(OUTOS)soft3d.dep: $(SRC.SOFT3D)
	$(DO.DEP)
else
-include $(OUTOS)soft3d.dep
endif

endif # ifeq ($(MAKESECTION),targets)
