/*
  Crystal Space Windowing System: title bar class
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __CSTTLBAR_H__
#define __CSTTLBAR_H__

#include "csutil/csbase.h"
#include "cscomp.h"

/**
 * The TitleBar class represents a bar with a text string written across
 * which is usually drawn at the top of complex windows :-).
 */
class csTitleBar : public csComponent
{
public:
  /// Create title bar object
  csTitleBar (csComponent *iParent, char *iTitle);

  /// Draw the title bar
  virtual void Draw ();

  /// Handle input events
  virtual bool HandleEvent (csEvent &Event);
};

#endif // __CSTTLBAR_H__
