/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GSPR3D_H
#define GSPR3D_H

#include "gobject.h"

class gePhysicalObject;

class geSprite3D : public geObject
{
  typedef geObject inherited;
public:
  geSprite3D(gePhysicalObject* pMaster);
  ~geSprite3D();
  IMPLEMENT_GETYPEINFO(geSprite3D)

  void Create   (gePosition Pos, const char* TemplateName, const char* Action);
  void SetAction(char* Action, bool looped);

  csSprite3D* GetCsSprite() {return m_pSprite;}

  virtual void PrepareFrame(long ElapsedTime, long CurrentTime);

  bool FindFirstCollision(csVector3 Offset, gePosition& NewPosition, gePhysicalObject*& pOther);
  virtual void OnCollision(gePhysicalObject* pOther);

  gePhysicalObject* GetMaster() {return m_pMaster;}

protected:
  virtual void OnMove(gePosition OldPos);

  bool              m_AnimateLooped;
  gePhysicalObject* m_pMaster;
  csSprite3D*       m_pSprite;
  geCollider*       m_pCollider;
};

#endif //GSPR3D_H