/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GPOSITION_H
#define GPOSITION_H

/**
 * gePositon will store a CS usable position. That means not just the 
 * position vector, but also a pointer to the according sector.
 */
class gePosition 
{
public:
  gePosition();
  gePosition(csSector* pSector, csVector3 Pos);
  gePosition(const gePosition& Pos);
  ~gePosition();

  //Move the Position by a relative Vector. 
  //returns false, if that move is not possible
  bool Move  (csVector3           Offset);

  //Sets a new Position
  void MoveTo(const gePosition& Pos);

  //Trys to Move the position to the given Vector. That can only be done, 
  //if the direct path is notblocked by any walls. (Sprites dont count 
  //here...)
  //returns false, if that move is not possible
  bool MoveTo(csVector3           Pos);

  //Sets the current position:
  void MoveTo(csSector* pSector, csVector3 Pos);

  //Gets the current sector.
  csSector* GetSector()   {return m_pSector;}

  //Return the Position without the sector
  operator csVector3() {return m_Pos;}

  //Gets the current position in the world.
  csVector3   GetPosition() {return m_Pos;}

protected:
  csSector* m_pSector;
  csVector3   m_Pos;
};

#endif