/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GOBJECT_H
#define GOBJECT_H

#include "gpos.h" //for gePosition

const DWORD Type_geObject         = 0;
const DWORD Type_geLight          = 1;
const DWORD Type_geContainer      = 2;
const DWORD Type_geWorld          = 3;
const DWORD Type_geSprite3D       = 4;
const DWORD Type_geSound          = 5;
const DWORD Type_gePhysicalObject = 6;
const DWORD Type_geBeing          = 7;
const DWORD Type_geItem           = 8;
const DWORD Type_geBullet         = 9;
const DWORD Type_gePlayer         = 10;
const DWORD Type_geMonster        = 11;
const DWORD Type_geExplosion      = 12;
const DWORD Type_geSentry         = 13;

#define IMPLEMENT_GETYPEINFO(class) \
  virtual bool IsOfType(DWORD Type) \
  {if (Type==Type_##class) {return true;} \
   else {return inherited::IsOfType(Type);}};

class geWorld;
class geContainer;

class geObject
{
public:
  geObject(geContainer* pContainer);
  virtual ~geObject();
  virtual bool IsOfType(DWORD Type);

  virtual void SetPosition(csSector* pSector, csVector3 Pos); 
  virtual void SetPosition(gePosition Pos);
  virtual gePosition GetPosition()         {return m_Pos;}

/** Gets called, when ever this object is moved in a relative manner. This
  * will do some generic collision detection, using m_pSprite if there is
  * one,
  * 
  * Param:
  * Offset: The releative move.
  * return: false, if there was a collision
  */
  virtual bool Move  (csVector3 Offset);

  virtual void StartMoveTo(csVector3 Destination, float speed);
  virtual void StartMove  (csVector3 Direction,   float speed);
  virtual void StopMove();

  virtual void PrepareFrame(long ElapsedTime, long CurrentTime);

  virtual void HandleWorldCollision() {StopMove();}

  virtual geContainer* GetParent();
  virtual geWorld*     GetWorld();

  virtual void Destroy();

protected:
  virtual void OnMove(gePosition /*OldPos*/) {;}

  //A pointer to the geWorld object. That pointer will allow us to reach
  //other objects, as well as the Crystal Space Engine
  geWorld*   m_pWorld;

  //The parent is the object that is managing this instance. In most cases
  //this will also be the world. But that could be any class derived from
  //geContainer.
  geContainer* m_pParent;

  //All Game objects will have some position and the possibility to move
  //at a certain speed, till a certain distance has passed.
  gePosition m_Pos;
  csVector3  m_SpeedVector;
  float      m_Speed;
  float      m_DistanceLeftToTravel;
};

#endif //GOBJECT_H