# Copyright charles vidal 08.1998  vidalc@club-internet.fr
global toto0
global toto1
global toto2
global thelist

set pathdocfile ../docs/*.txt

proc openfilesel { var } {
upvar $var toto
set toto [ tk_getOpenFile -parent . ]
}

proc putinguilist { lst } {
global toto0
set w  .thel.f.t
foreach i $lst {
        lappend toto0 [$w index current]
 	.t.f.names insert end " [lindex $i 0]"
#if {  [lindex $i 2] == 1 } then {.t.f.names insert end "    [lindex $i 0]"} else {.t.f.names insert end " [lindex $i 0]"}
        insertWithTags  $w "[lindex $i 0] " big
         $w insert end "\n"
         $w insert end [lindex $i 1]
         $w insert end "\n"
	}
}


#
# insert text with tag in text area
#
proc insertWithTags {w text args} {
    set start [$w index insert]
    $w insert insert $text
    foreach tag [$w tag names $start] {
        $w tag remove $tag $start insert
    }
    foreach i $args {
        $w tag add $i $start insert
    }
}

# Function for the help
proc mkHelpCheck { w args } {
  set nbf 0
  foreach i $args {
        set nbf [ expr $nbf +1 ]
        $w insert insert  "\n"
        checkbutton $w.c$nbf -variable [lindex $i 0] -text [lindex $i 0]
        $w window create {end lineend} -window $w.c$nbf
        $w insert insert  " [lindex $i 1] "
        }
}
# function to into  move the textarea
proc moveintext { indx } {
upvar toto0 t1
 .thetext.t yview  [ lindex $t1 $indx ]
}

#main
toplevel .thel
toplevel .thetext 
wm  iconify .thetext
wm  iconify .thel
puts $pathdocfile
set listofdoc [ glob $pathdocfile ]
#----------------------
# The Menu 
#------------------------
frame .menu -relief raised -borderwidth 1
menubutton .menu.file -text "File" -menu .menu.file.check
menubutton .menu.help -text "Help" -menu .menu.help.check
pack .menu -side top -fill x

#----------------------
# The Liste
#------------------------
frame .thel.f
listbox .thel.f.names -width 40 -height 20  -yscrollcommand ".thel.f.scroll set" 
scrollbar .thel.f.scroll -orient vertical -command ".thel.f.names yview"
set toto0 " " 
pack .thel.f -expand yes -fill both -expand yes
pack .thel.f.names  -fill both -side left -expand yes
pack  .thel.f.scroll  -side right  -fill y

bind .thel.f.names <Double-1> {
set titi [eval .thel.f.names curselection]
#set toto0 { {1.0} {4.0} {7.0} }
moveintext $titi
}
#--------------------
#the texte 
#--------------------
set t1  .thetext
text  $t1.t -yscrollcommand {.thetext.s set}  -wrap none -width 60 -height 20 \
        -setgrid 1 
scrollbar $t1.s -orient vertical -command {.thetext.t  yview}

set w  .thetext.t

$w tag configure big -font -Adobe-Courier-Bold-R-Normal-*-180-*
$w tag configure medium -font -Adobe-Courier-Bold-R-Normal-*-120-*

pack  $t1.s  -side right  -fill y
pack $t1.t  -side left -fill both  -expand yes

# parse HOWTO FILE 

#
# Open file
#

#
# top level message for loading  frame 
#
toplevel .info
label .info.mesg
pack .info.mesg -expand yes -fill x
update


# Read Doc
#
foreach i $listofdoc {
        insertWithTags  .thetext.t  [lindex $i 0]  big
        insertWithTags  .thetext.t "\n"
        .thel.f.names insert end "$i"
        set filenom $i
	.info.mesg configure -text "Loading $filenom"
	puts $filenom
        set f [open $filenom]
        lappend toto0 [.thetext.t index current]
	update
	update
        while {[ gets $f line] >= 0} {
                $w insert end $line
                $w insert end "\n"
         }
        close $f
}
destroy .info
wm deiconify .thetext
wm deiconify .thel
